/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions;

import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.util.io.Compressor;
import java.io.File;
import java.util.HashSet;
import java.util.function.BiPredicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExportProjectZip
extends AnAction
implements DumbAware {
    public void update(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        e.getPresentation().setEnabled(project != null && !project.isDefault());
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        final Project project = e.getProject();
        assert (project != null);
        FileSaverDialog saver = FileChooserFactory.getInstance().createSaveFileDialog(new FileSaverDescriptor("Save Project As Zip", "Save to", new String[]{"zip"}), project);
        final VirtualFileWrapper target = saver.save(null, project.getName() + "." + "zip");
        if (target != null) {
            Task.Backgroundable task2 = new Task.Backgroundable(project, "Saving Project Zip"){

                public void run(@NotNull ProgressIndicator indicator) {
                    ExportProjectZip.save(target.getFile(), project, indicator);
                }
            };
            ProgressManager.getInstance().runProcessWithProgressAsynchronously(task2, (ProgressIndicator)new BackgroundableProcessIndicator(task2));
        }
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    static void save(@NotNull File zipFile, @NotNull Project project, @Nullable ProgressIndicator indicator) {
        HashSet<File> allRoots = new HashSet<File>();
        HashSet<File> excludes = new HashSet<File>();
        excludes.add(zipFile);
        assert (project.getBasePath() != null);
        File basePath = new File(FileUtil.toSystemDependentName((String)project.getBasePath()));
        allRoots.add(basePath);
        excludes.add(new File(basePath, "local.properties"));
        boolean gradle = GradleProjectInfo.getInstance(project).isBuildWithGradle();
        if (gradle) {
            excludes.add(new File(basePath, ".gradle"));
            excludes.add(new File(basePath, "build"));
            excludes.add(new File(basePath, ".idea"));
            excludes.add(new File(basePath, "captures"));
        }
        for (Module module2 : ModuleManager.getInstance((Project)project).getModules()) {
            void var16_26;
            VirtualFile[] virtualFileArray;
            VirtualFile[] contentRoots;
            VirtualFile moduleFile;
            if (gradle && (moduleFile = module2.getModuleFile()) != null) {
                excludes.add(VfsUtilCore.virtualToIoFile((VirtualFile)moduleFile));
            }
            ModuleRootManager roots = ModuleRootManager.getInstance((Module)module2);
            for (VirtualFile virtualFile : contentRoots = roots.getContentRoots()) {
                allRoots.add(VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile));
            }
            VirtualFile[] virtualFileArray2 = virtualFileArray = roots.getExcludeRoots();
            int n = virtualFileArray2.length;
            boolean bl = false;
            while (var16_26 < n) {
                VirtualFile root3 = virtualFileArray2[var16_26];
                excludes.add(VfsUtilCore.virtualToIoFile((VirtualFile)root3));
                ++var16_26;
            }
        }
        File commonRoot = null;
        for (File root4 : allRoots) {
            if ((commonRoot = commonRoot == null ? root4 : FileUtil.findAncestor((File)commonRoot, (File)root4)) != null) continue;
            throw new IllegalArgumentException("no common root found");
        }
        assert (commonRoot != null);
        FileTypeManager fileTypeManager = FileTypeManager.getInstance();
        BiPredicate<String, File> filter2 = (entryName, file2) -> {
            if (fileTypeManager.isFileIgnored(file2.getName()) || excludes.stream().anyMatch(root2 -> FileUtil.isAncestor((File)root2, (File)file2, (boolean)false))) {
                return false;
            }
            if (!file2.exists()) {
                Logger.getInstance(ExportProjectZip.class).info("Skipping broken symlink: " + file2);
                return false;
            }
            boolean isDir = file2.isDirectory();
            if (allRoots.stream().noneMatch(root2 -> isDir && FileUtil.isAncestor((File)file2, (File)root2, (boolean)false) || FileUtil.isAncestor((File)root2, (File)file2, (boolean)false))) {
                return false;
            }
            if (indicator != null) {
                indicator.setText(entryName);
            }
            return true;
        };
        try (Compressor.Zip zip = new Compressor.Zip(zipFile);){
            zip.filter(filter2);
            File[] children = commonRoot.listFiles();
            if (children != null) {
                for (File file3 : children) {
                    String childRelativePath = (FileUtil.filesEqual((File)commonRoot, (File)basePath) ? commonRoot.getName() + '/' : "") + file3.getName();
                    if (file3.isDirectory()) {
                        zip.addDirectory(childRelativePath, file3);
                        continue;
                    }
                    zip.addFile(childRelativePath, file3);
                }
            }
        }
        catch (Exception ex) {
            Logger.getInstance(ExportProjectZip.class).info("error making zip", (Throwable)ex);
            ApplicationManager.getApplication().invokeLater(() -> Messages.showErrorDialog((Project)project, (String)("Error: " + ex), (String)"Error!"));
        }
    }
}

