/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions;

import com.android.tools.idea.actions.AnnotateTask;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.ArtifactDependencyModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.DependenciesModel;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.repositories.RepositoryUrlManager;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.projectsystem.GoogleMavenArtifactId;
import com.android.tools.idea.projectsystem.ProjectSystemSyncManager;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.util.DependencyManagementUtil;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.BaseAnalysisActionDialog;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInspection.inferNullity.InferNullityAnnotationsAction;
import com.intellij.codeInspection.inferNullity.NullityInferrer;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageInfoSearcherAdapter;
import com.intellij.usages.UsageSearcher;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.util.Processor;
import com.intellij.util.SequentialModalProgressTask;
import com.intellij.util.SequentialTask;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.android.refactoring.MigrateToAndroidxUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidInferNullityAnnotationAction
extends InferNullityAnnotationsAction {
    private static final Logger LOG = Logger.getInstance(AndroidInferNullityAnnotationAction.class);
    private static final String INFER_NULLITY_ANNOTATIONS = "Infer Nullity Annotations";
    private static final String ADD_DEPENDENCY = "Add Support Dependency";
    private static final int MIN_SDK_WITH_NULLABLE = 19;

    protected void analyze(@NotNull Project project, @NotNull AnalysisScope scope2) {
        AndroidInferNullityAnnotationAction.setUpNullityAnnotationDefaults(project);
        if (!GradleProjectInfo.getInstance(project).isBuildWithGradle()) {
            super.analyze(project, scope2);
            return;
        }
        int[] fileCount2 = new int[]{0};
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        UsageInfo[] usageInfos = this.findUsages(project, scope2, fileCount2[0]);
        if (usageInfos == null) {
            return;
        }
        Map<Module, PsiFile> modules = AndroidInferNullityAnnotationAction.findModulesFromUsage(usageInfos);
        if (!this.checkModules(project, scope2, modules)) {
            return;
        }
        if (usageInfos.length < 5) {
            ApplicationManager.getApplication().invokeLater(AndroidInferNullityAnnotationAction.applyRunnable(project, (Computable<UsageInfo[]>)((Computable)() -> usageInfos)));
        } else {
            AndroidInferNullityAnnotationAction.showUsageView(project, usageInfos, scope2, this);
        }
    }

    private static void setUpNullityAnnotationDefaults(@NotNull Project project) {
        NullableNotNullManager nullityManager = NullableNotNullManager.getInstance((Project)project);
        if (Arrays.stream(ModuleManager.getInstance((Project)project).getModules()).anyMatch(module2 -> DependencyManagementUtil.dependsOnAndroidx(module2))) {
            nullityManager.setDefaultNotNull("androidx.annotation.NonNull");
            nullityManager.setDefaultNullable("androidx.annotation.Nullable");
        } else {
            nullityManager.setDefaultNotNull("android.support.annotation.NonNull");
            nullityManager.setDefaultNullable("android.support.annotation.Nullable");
        }
    }

    private static Map<Module, PsiFile> findModulesFromUsage(UsageInfo[] infos) {
        HashMap<Module, PsiFile> modules = new HashMap<Module, PsiFile>();
        for (UsageInfo info2 : infos) {
            PsiElement element2 = info2.getElement();
            assert (element2 != null);
            Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)element2);
            PsiFile file2 = element2.getContainingFile();
            modules.put(module2, file2);
        }
        return modules;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean checkModules(final @NotNull Project project, final @NotNull AnalysisScope scope2, @NotNull Map<Module, PsiFile> modules) {
        final HashSet<Module> modulesWithoutAnnotations = new HashSet<Module>();
        HashSet<Module> modulesWithLowVersion = new HashSet<Module>();
        for (Module module2 : modules.keySet()) {
            GradleBuildModel buildModel;
            AndroidModuleInfo info2 = AndroidModuleInfo.getInstance(module2);
            if (info2 != null && info2.getBuildSdkVersion() != null && info2.getBuildSdkVersion().getFeatureLevel() < 19) {
                modulesWithLowVersion.add(module2);
            }
            if ((buildModel = GradleBuildModel.get(module2)) == null) {
                LOG.warn("Unable to find Gradle build model for module " + module2.getModuleFilePath());
                continue;
            }
            boolean dependencyFound = false;
            DependenciesModel dependenciesModel = buildModel.dependencies();
            if (dependenciesModel != null) {
                String configurationName = GradleUtil.mapConfigurationName("compile", GradleUtil.getAndroidGradleModelVersionInUse(module2), false);
                for (ArtifactDependencyModel dependency : dependenciesModel.artifacts(configurationName)) {
                    String notation = dependency.compactNotation();
                    if (!notation.startsWith(GoogleMavenArtifactId.APP_COMPAT_V7.toString()) && !notation.startsWith(GoogleMavenArtifactId.ANDROIDX_APP_COMPAT_V7.toString()) && !notation.startsWith(GoogleMavenArtifactId.SUPPORT_V4.toString()) && !notation.startsWith(GoogleMavenArtifactId.ANDROIDX_SUPPORT_V4.toString()) && !notation.startsWith(GoogleMavenArtifactId.SUPPORT_ANNOTATIONS.toString()) && !notation.startsWith(GoogleMavenArtifactId.ANDROIDX_SUPPORT_ANNOTATIONS.toString())) continue;
                    dependencyFound = true;
                    break;
                }
            }
            if (dependencyFound) continue;
            modulesWithoutAnnotations.add(module2);
        }
        if (!modulesWithLowVersion.isEmpty()) {
            Messages.showErrorDialog((Project)project, (String)String.format(Locale.US, "Infer Nullity Annotations requires the project sdk level be set to %1$d or greater.", 19), (String)INFER_NULLITY_ANNOTATIONS);
            return false;
        }
        if (modulesWithoutAnnotations.isEmpty()) {
            return true;
        }
        String moduleNames = StringUtil.join(modulesWithoutAnnotations, Module::getName, (String)", ");
        int count = modulesWithoutAnnotations.size();
        String message2 = String.format("The %1$s %2$s %3$sn't refer to the existing '%4$s' library with Android nullity annotations. \n\nWould you like to add the %5$s now?", StringUtil.pluralize((String)"module", (int)count), moduleNames, count > 1 ? "do" : "does", GoogleMavenArtifactId.SUPPORT_ANNOTATIONS.getMavenArtifactId(), StringUtil.pluralize((String)"dependency", (int)count));
        if (Messages.showOkCancelDialog((Project)project, (String)message2, (String)INFER_NULLITY_ANNOTATIONS, (Icon)Messages.getErrorIcon()) == 0) {
            LocalHistoryAction action2 = LocalHistory.getInstance().startAction(ADD_DEPENDENCY);
            try {
                new WriteCommandAction(project, ADD_DEPENDENCY, new PsiFile[0]){

                    protected void run(@NotNull Result result2) throws Throwable {
                        RepositoryUrlManager manager = RepositoryUrlManager.get();
                        GoogleMavenArtifactId annotation = MigrateToAndroidxUtil.isAndroidx(project) ? GoogleMavenArtifactId.ANDROIDX_SUPPORT_ANNOTATIONS : GoogleMavenArtifactId.SUPPORT_ANNOTATIONS;
                        String annotationsLibraryCoordinate = manager.getArtifactStringCoordinate(annotation, true);
                        for (Module module2 : modulesWithoutAnnotations) {
                            AndroidInferNullityAnnotationAction.addDependency(module2, annotationsLibraryCoordinate);
                        }
                        AndroidInferNullityAnnotationAction.this.syncAndRestartAnalysis(project, scope2);
                    }
                }.execute();
            }
            finally {
                action2.finish();
            }
        }
        return false;
    }

    private void syncAndRestartAnalysis(final @NotNull Project project, final @NotNull AnalysisScope scope2) {
        assert (ApplicationManager.getApplication().isDispatchThread());
        ListenableFuture<ProjectSystemSyncManager.SyncResult> syncResult = ProjectSystemUtil.getProjectSystem(project).getSyncManager().syncProject(ProjectSystemSyncManager.SyncReason.PROJECT_MODIFIED);
        Futures.addCallback(syncResult, (FutureCallback)new FutureCallback<ProjectSystemSyncManager.SyncResult>(){

            public void onSuccess(@Nullable ProjectSystemSyncManager.SyncResult syncResult) {
                if (syncResult != null && syncResult.isSuccessful()) {
                    AndroidInferNullityAnnotationAction.this.restartAnalysis(project, scope2);
                }
            }

            public void onFailure(@Nullable Throwable t) {
                throw new RuntimeException(t);
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    private static Runnable applyRunnable(final Project project, final Computable<UsageInfo[]> computable) {
        return () -> {
            LocalHistoryAction action2 = LocalHistory.getInstance().startAction(INFER_NULLITY_ANNOTATIONS);
            try {
                new WriteCommandAction(project, INFER_NULLITY_ANNOTATIONS, new PsiFile[0]){

                    protected void run(@NotNull Result result2) throws Throwable {
                        UsageInfo[] infos = (UsageInfo[])computable.compute();
                        if (infos.length > 0) {
                            LinkedHashSet elements = new LinkedHashSet();
                            for (UsageInfo info2 : infos) {
                                PsiElement element2 = info2.getElement();
                                if (element2 == null) continue;
                                ContainerUtil.addIfNotNull(elements, (Object)element2.getContainingFile());
                            }
                            if (!FileModificationService.getInstance().preparePsiElementsForWrite(elements)) {
                                return;
                            }
                            SequentialModalProgressTask progressTask = new SequentialModalProgressTask(project, AndroidInferNullityAnnotationAction.INFER_NULLITY_ANNOTATIONS, false);
                            progressTask.setMinIterationTime(200L);
                            progressTask.setTask((SequentialTask)new AnnotateTask(project, progressTask, infos));
                            ProgressManager.getInstance().run((Task)progressTask);
                        } else {
                            NullityInferrer.nothingFoundMessage((Project)project);
                        }
                    }
                }.execute();
            }
            finally {
                action2.finish();
            }
        };
    }

    protected void restartAnalysis(Project project, AnalysisScope scope2) {
        ApplicationManager.getApplication().invokeLater(() -> this.analyze(project, scope2));
    }

    private static void showUsageView(@NotNull Project project, UsageInfo[] usageInfos, @NotNull AnalysisScope scope2, AndroidInferNullityAnnotationAction action2) {
        UsageTarget[] targets = UsageTarget.EMPTY_ARRAY;
        Ref convertUsagesRef = new Ref();
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ApplicationManager.getApplication().runReadAction(() -> convertUsagesRef.set((Object)UsageInfo2UsageAdapter.convert((UsageInfo[])usageInfos))), "Preprocess Usages", true, project)) {
            return;
        }
        if (convertUsagesRef.isNull()) {
            return;
        }
        Usage[] usages = (Usage[])convertUsagesRef.get();
        UsageViewPresentation presentation = new UsageViewPresentation();
        presentation.setTabText("Infer Nullity Preview");
        presentation.setShowReadOnlyStatusAsRed(true);
        presentation.setShowCancelButton(true);
        presentation.setUsagesString(RefactoringBundle.message((String)"usageView.usagesText"));
        UsageView usageView = UsageViewManager.getInstance((Project)project).showUsages(targets, usages, presentation, AndroidInferNullityAnnotationAction.rerunFactory(project, scope2, action2));
        Runnable refactoringRunnable2 = AndroidInferNullityAnnotationAction.applyRunnable(project, (Computable<UsageInfo[]>)((Computable)() -> {
            Set infos = UsageViewUtil.getNotExcludedUsageInfos((UsageView)usageView);
            return infos.toArray(UsageInfo.EMPTY_ARRAY);
        }));
        String canNotMakeString = "Cannot perform operation.\nThere were changes in code after usages have been found.\nPlease perform operation search again.";
        usageView.addPerformOperationAction(refactoringRunnable2, INFER_NULLITY_ANNOTATIONS, canNotMakeString, INFER_NULLITY_ANNOTATIONS, false);
    }

    @NotNull
    private static Factory<UsageSearcher> rerunFactory(final @NotNull Project project, final @NotNull AnalysisScope scope2, final AndroidInferNullityAnnotationAction action2) {
        return () -> new UsageInfoSearcherAdapter(){

            protected UsageInfo[] findUsages() {
                return action2.findUsages(project, scope2, scope2.getFileCount());
            }

            public void generate(@NotNull Processor<? super Usage> processor) {
                this.processUsages(processor, project);
            }
        };
    }

    private static void addDependency(@NotNull Module module2, @Nullable String libraryCoordinate) {
        if (StringUtil.isNotEmpty((String)libraryCoordinate)) {
            ModuleRootModificationUtil.updateModel((Module)module2, model2 -> {
                GradleBuildModel buildModel = GradleBuildModel.get(module2);
                if (buildModel != null) {
                    String name = GradleUtil.mapConfigurationName("compile", GradleUtil.getAndroidGradleModelVersionInUse(module2), false);
                    buildModel.dependencies().addArtifact(name, libraryCoordinate);
                    buildModel.applyChanges();
                }
            });
        }
    }

    protected JComponent getAdditionalActionSettings(Project project, BaseAnalysisActionDialog dialog2) {
        JComponent panel2 = super.getAdditionalActionSettings(project, dialog2);
        if (panel2 != null && GradleProjectInfo.getInstance(project).isBuildWithGradle()) {
            panel2.setVisible(false);
        }
        return panel2;
    }
}

