/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution.ui.panels;

import com.android.build.attribution.ui.BuildAttributionUIUtilKt;
import com.android.build.attribution.ui.data.TimeWithPercentage;
import com.android.build.attribution.ui.panels.CriticalPathChartLegend;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class TimeDistributionChart<T>
extends JPanel {
    private static final int MIN_OTHER_TASKS_SECTION_HEIGHT_PX = 25;
    private static final int PIXELS_BY_PERCENT = 2;
    private final JBFont myMonospacedFont = JBUI.Fonts.create((String)"Monospaced", (int)JBUI.Fonts.label().getSize());
    private final List<ChartItem> myChartItems;
    private final ChartDataItem<T> myHighlightedItem;

    public TimeDistributionChart(List<ChartDataItem<T>> dataItems, ChartDataItem<T> highlightedItem, boolean fullTable) {
        super(new GridBagLayout());
        this.myHighlightedItem = highlightedItem;
        this.myChartItems = ContainerUtil.map(dataItems, x$0 -> new ChartItem((ChartDataItem)x$0));
        JPanel table2 = fullTable ? this.createFullPluginsTable() : this.createShortPluginsTable();
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 23;
        c.gridy = 0;
        c.gridx = 0;
        c.weightx = 0.0;
        c.weighty = 1.0;
        c.fill = 3;
        this.add((Component)((Object)new ChartPane()), c);
        c.gridx = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        this.add((Component)table2, c);
    }

    private JPanel createFullPluginsTable() {
        JPanel panel2 = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        this.myChartItems.forEach(item -> {
            c.weightx = 0.0;
            c.anchor = 21;
            c.insets = JBUI.emptyInsets();
            c.gridx = 0;
            c.insets = JBUI.insets((int)0, (int)9, (int)0, (int)0);
            panel2.add((Component)item.myTimeLabel, c);
            c.gridx = 1;
            c.anchor = 22;
            panel2.add((Component)this.createTableLabel(BuildAttributionUIUtilKt.percentageString(item.time()), (ChartItem)item), c);
            c.gridx = 2;
            panel2.add((Component)new JBLabel(item.getTableIcon()), c);
            c.gridx = 3;
            c.anchor = 21;
            c.weightx = 1.0;
            panel2.add((Component)this.createTableLabel(item.text(), (ChartItem)item), c);
            ++c.gridy;
        });
        return panel2;
    }

    private JPanel createShortPluginsTable() {
        JPanel panel2 = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        this.myChartItems.forEach(item -> {
            c.gridx = 0;
            c.weightx = 0.0;
            c.anchor = 21;
            c.insets = JBUI.emptyInsets();
            c.insets = JBUI.insets((int)0, (int)9, (int)0, (int)0);
            panel2.add((Component)item.myTimeLabel, c);
            ++c.gridy;
        });
        return panel2;
    }

    private JBLabel createTableLabel(String text2, ChartItem item) {
        JBLabel label = new JBLabel(text2);
        label.setForeground(item.getTableTextColor());
        return label;
    }

    private class ChartPane
    extends JBPanel<ChartPane> {
        private final int myChartBoxMarginPx = JBUIScale.scale((int)1);
        private final int myMinCursorHeight = JBUIScale.scale((int)10);
        private final int myCursorWidth = JBUIScale.scale((int)10);
        private final int myChartBoxWidth = JBUIScale.scale((int)100);
        private final int myConnectorsWidth = JBUIScale.scale((int)50);
        private final int myBulletSize = JBUIScale.scale((int)5);
        private final int myBulletSelectionBorderThickness = JBUIScale.scale((int)2);
        private final int mySelectedBulletWidth = this.myBulletSize + 2 * this.myBulletSelectionBorderThickness;
        private final int myCursorLeftBoundX = 0;
        private final int myChartBoxLeftBoundX = 0 + this.myCursorWidth + this.myChartBoxMarginPx;
        private final int myConnectorLeftBoundX = this.myChartBoxLeftBoundX + this.myChartBoxWidth;
        private final int myBulletLeftBoundX = this.myConnectorLeftBoundX + this.myConnectorsWidth;
        private final int myChartWidth = this.myBulletLeftBoundX + this.mySelectedBulletWidth;

        private ChartPane() {
            int itemsHeightSum = TimeDistributionChart.this.myChartItems.stream().mapToInt(item -> item.myChartBoxHeight).sum();
            int itemsNumber = TimeDistributionChart.this.myChartItems.size();
            int minHeight = this.myMinCursorHeight + itemsHeightSum + itemsNumber * this.myChartBoxMarginPx + this.myMinCursorHeight;
            this.withMinimumHeight(minHeight);
            this.withPreferredHeight(minHeight);
            this.withMinimumWidth(this.myChartWidth);
            this.withMaximumWidth(this.myChartWidth);
            this.withPreferredWidth(this.myChartWidth);
        }

        protected void paintComponent(Graphics g) {
            GraphicsUtil.setupAntialiasing((Graphics)g);
            GraphicsUtil.setupAAPainting((Graphics)g);
            super.paintComponent(g);
            int curY = this.myMinCursorHeight;
            for (ChartItem item : TimeDistributionChart.this.myChartItems) {
                g.setColor(item.myBaseColor);
                this.drawMainBox(g, item, curY);
                this.drawBulletPoint(g, item);
                this.drawConnector(g, item, curY);
                if (item.isSelected()) {
                    this.drawCursor(g, item, curY);
                }
                if (item.myDataItem.chartBoxText() != null) {
                    this.drawTextInBox(g, item, curY);
                }
                curY += item.myChartBoxHeight + this.myChartBoxMarginPx;
            }
        }

        private void drawMainBox(Graphics g, ChartItem item, int curY) {
            g.fillRect(this.myChartBoxLeftBoundX, curY, this.myChartBoxWidth, item.myChartBoxHeight);
        }

        private void drawTextInBox(Graphics g, ChartItem item, int curY) {
            g.setFont((Font)JBUI.Fonts.smallFont());
            g.setColor(CriticalPathChartLegend.OTHER_TASKS_TEXT_COLOR);
            String boxText = item.myDataItem.chartBoxText();
            FontMetrics metrics = g.getFontMetrics();
            int textWidth = metrics.stringWidth(boxText);
            int textX = this.myChartBoxLeftBoundX + (this.myChartBoxWidth - textWidth) / 2;
            int textMiddleY = metrics.getAscent() / 2;
            int textY = curY + item.myChartBoxHeight / 2 + textMiddleY;
            g.drawString(boxText, textX, textY);
        }

        private void drawBulletPoint(Graphics g, ChartItem item) {
            int bulletX = this.myBulletLeftBoundX + this.myBulletSelectionBorderThickness;
            int rowCenterY = item.getRowCenterVerticalLocation();
            int bulletY = rowCenterY - this.myBulletSize / 2;
            g.fillRect(bulletX, bulletY, this.myBulletSize, this.myBulletSize);
            if (item.isSelected()) {
                int borderSize = this.myBulletSize + 2 * this.myBulletSelectionBorderThickness - 1;
                int borderY = bulletY - this.myBulletSelectionBorderThickness;
                g.drawRoundRect(this.myBulletLeftBoundX, borderY, borderSize, borderSize, 4, 4);
            } else {
                g.drawLine(this.myBulletLeftBoundX, rowCenterY, this.myBulletLeftBoundX + this.myBulletSelectionBorderThickness, rowCenterY);
            }
        }

        private void drawConnector(Graphics g, ChartItem item, int curY) {
            int leftY = curY + item.myChartBoxHeight / 2;
            int rightX = this.myConnectorLeftBoundX + this.myConnectorsWidth;
            int rightY = item.getRowCenterVerticalLocation();
            g.drawLine(this.myConnectorLeftBoundX, leftY, rightX, rightY);
        }

        private void drawCursor(Graphics g, ChartItem item, int curY) {
            int rightX = 0 + this.myCursorWidth;
            if (this.myMinCursorHeight > item.myChartBoxHeight) {
                int middleY = curY + item.myChartBoxHeight / 2;
                int leftTopY = middleY - this.myMinCursorHeight / 2;
                int leftBottomY = middleY + this.myMinCursorHeight / 2;
                g.fillPolygon(new int[]{0, 0, rightX, rightX}, new int[]{leftTopY, leftBottomY, curY + item.myChartBoxHeight, curY}, 4);
            } else {
                g.fillRect(0, curY, this.myCursorWidth, item.myChartBoxHeight);
            }
        }
    }

    private class ChartItem {
        @NotNull
        final ChartDataItem<T> myDataItem;
        @NotNull
        final Color myBaseColor;
        final int myChartBoxHeight;
        @NotNull
        final JBLabel myTimeLabel;

        private ChartItem(ChartDataItem<T> dataItem) {
            this.myDataItem = dataItem;
            this.myChartBoxHeight = JBUIScale.scale((int)this.calculateBoxHeightPx());
            this.myBaseColor = this.myDataItem.getLegendColor().baseColor;
            this.myTimeLabel = TimeDistributionChart.this.createTableLabel(String.format("%.1fs", this.time().getTimeS()), this).withFont(TimeDistributionChart.this.myMonospacedFont);
        }

        private int calculateBoxHeightPx() {
            int minHeightPixels = 2;
            if (this.myDataItem.chartBoxText() != null) {
                minHeightPixels = 25;
            }
            int heightInPercentage = (int)Math.round(Math.ceil(this.time().getPercentage()));
            int heightInPixels = heightInPercentage * 2;
            return Math.max(heightInPixels, minHeightPixels);
        }

        public TimeWithPercentage time() {
            return this.myDataItem.time();
        }

        public String text() {
            return this.myDataItem.text();
        }

        public Icon getTableIcon() {
            return this.myDataItem.getTableIcon();
        }

        private boolean isSelected() {
            return TimeDistributionChart.this.myHighlightedItem == this.myDataItem;
        }

        private Color getTableTextColor() {
            if (TimeDistributionChart.this.myHighlightedItem == null) {
                return this.myDataItem.selectedTextColor();
            }
            if (this.isSelected()) {
                return this.myDataItem.selectedTextColor();
            }
            return this.myDataItem.unselectedTextColor();
        }

        private int getRowCenterVerticalLocation() {
            return this.myTimeLabel.getY() + this.myTimeLabel.getHeight() / 2;
        }
    }

    public static interface AggregatedChartDataItem<T>
    extends ChartDataItem<T> {
        public List<T> getUnderlyingData();
    }

    public static interface SingularChartDataItem<T>
    extends ChartDataItem<T> {
        public T getUnderlyingData();
    }

    public static interface ChartDataItem<T> {
        public TimeWithPercentage time();

        public String text();

        public Icon getTableIcon();

        public CriticalPathChartLegend.ChartColor getLegendColor();

        public String chartBoxText();

        default public Color selectedTextColor() {
            return UIUtil.getActiveTextColor();
        }

        default public Color unselectedTextColor() {
            return UIUtil.getInactiveTextColor();
        }
    }
}

