/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.editor;

import com.intellij.ide.structureView.FileEditorPositionListener;
import com.intellij.ide.structureView.ModelListener;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.util.treeView.smartTree.Filter;
import com.intellij.ide.util.treeView.smartTree.Grouper;
import com.intellij.ide.util.treeView.smartTree.Sorter;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.editor.PropertiesGroupingStructureViewModel;
import com.intellij.lang.properties.editor.PropertyStructureViewElement;
import com.intellij.lang.properties.editor.ResourceBundleFileStructureViewElement;
import com.intellij.lang.properties.structureView.GroupByWordPrefixes;
import com.intellij.lang.properties.structureView.PropertiesSeparatorManager;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

public class ResourceBundleStructureViewModel
implements PropertiesGroupingStructureViewModel {
    private final ResourceBundle myResourceBundle;
    private final GroupByWordPrefixes myByWordPrefixesGrouper;
    private volatile boolean myGrouped = true;
    private final ResourceBundleFileStructureViewElement myRoot;

    public ResourceBundleStructureViewModel(ResourceBundle root) {
        this.myResourceBundle = root;
        String separator = PropertiesSeparatorManager.getInstance((Project)root.getProject()).getSeparator(this.myResourceBundle);
        this.myByWordPrefixesGrouper = new GroupByWordPrefixes(separator);
        this.myRoot = new ResourceBundleFileStructureViewElement(this.myResourceBundle, () -> this.myGrouped);
    }

    public void setSeparator(String separator) {
        this.myByWordPrefixesGrouper.setSeparator(separator);
        PropertiesSeparatorManager.getInstance((Project)this.myResourceBundle.getProject()).setSeparator(this.myResourceBundle, separator);
    }

    public void setShowOnlyIncomplete(boolean showOnlyIncomplete) {
        this.myRoot.setShowOnlyIncomplete(showOnlyIncomplete);
    }

    public boolean isShowOnlyIncomplete() {
        return this.myRoot.isShowOnlyIncomplete();
    }

    public String getSeparator() {
        return this.myByWordPrefixesGrouper.getSeparator();
    }

    public void setGroupingActive(boolean state) {
        this.myGrouped = state;
    }

    @NotNull
    public StructureViewTreeElement getRoot() {
        return this.myRoot;
    }

    public Grouper @NotNull [] getGroupers() {
        return new Grouper[]{this.myByWordPrefixesGrouper};
    }

    public Sorter @NotNull [] getSorters() {
        return new Sorter[]{Sorter.ALPHA_SORTER};
    }

    public Filter @NotNull [] getFilters() {
        return Filter.EMPTY_ARRAY;
    }

    public Object getCurrentEditorElement() {
        return null;
    }

    public void addEditorPositionListener(@NotNull FileEditorPositionListener listener) {
    }

    public void removeEditorPositionListener(@NotNull FileEditorPositionListener listener) {
    }

    public void addModelListener(@NotNull ModelListener modelListener) {
    }

    public void removeModelListener(@NotNull ModelListener modelListener) {
    }

    public void dispose() {
    }

    public boolean shouldEnterElement(Object element) {
        return false;
    }

    public boolean isAlwaysShowsPlus(StructureViewTreeElement element) {
        return false;
    }

    public boolean isAlwaysLeaf(StructureViewTreeElement element) {
        return element instanceof PropertyStructureViewElement;
    }
}

