/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore.kdbx;

import com.intellij.credentialStore.kdbx.KdbxEntryKt;
import com.intellij.credentialStore.kdbx.KdbxGroup;
import com.intellij.credentialStore.kdbx.KeePassDatabase;
import com.intellij.credentialStore.kdbx.KeePassDatabaseKt;
import com.intellij.credentialStore.kdbx.ProtectedValueKt;
import com.intellij.credentialStore.kdbx.SecureString;
import com.intellij.credentialStore.kdbx.StringProtectedByStreamCipher;
import com.intellij.credentialStore.kdbx.UnsavedProtectedValue;
import com.intellij.util.JdomKt;
import com.intellij.util.text.StringKt;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Content;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u0016H\u0002J\u0012\u0010!\u001a\u0004\u0018\u00010\u00162\u0006\u0010\"\u001a\u00020\u0016H\u0002J$\u0010#\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u000f\u001a\u0004\u0018\u00010\u00162\u0006\u0010\"\u001a\u00020\u0016H\u0002J\b\u0010$\u001a\u00020%H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR(\u0010\u0011\u001a\u0004\u0018\u00010\u00102\b\u0010\u000f\u001a\u0004\u0018\u00010\u00108F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R(\u0010\u0017\u001a\u0004\u0018\u00010\u00162\b\u0010\u000f\u001a\u0004\u0018\u00010\u00168F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR(\u0010\u001c\u001a\u0004\u0018\u00010\u00162\b\u0010\u000f\u001a\u0004\u0018\u00010\u00168F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001d\u0010\u0019\"\u0004\b\u001e\u0010\u001b\u00a8\u0006&"}, d2={"Lcom/intellij/credentialStore/kdbx/KdbxEntry;", "", "entryElement", "Lorg/jdom/Element;", "database", "Lcom/intellij/credentialStore/kdbx/KeePassDatabase;", "group", "Lcom/intellij/credentialStore/kdbx/KdbxGroup;", "(Lorg/jdom/Element;Lcom/intellij/credentialStore/kdbx/KeePassDatabase;Lcom/intellij/credentialStore/kdbx/KdbxGroup;)V", "getEntryElement$intellij_platform_credentialStore", "()Lorg/jdom/Element;", "getGroup$intellij_platform_credentialStore", "()Lcom/intellij/credentialStore/kdbx/KdbxGroup;", "setGroup$intellij_platform_credentialStore", "(Lcom/intellij/credentialStore/kdbx/KdbxGroup;)V", "value", "Lcom/intellij/credentialStore/kdbx/SecureString;", "password", "getPassword", "()Lcom/intellij/credentialStore/kdbx/SecureString;", "setPassword", "(Lcom/intellij/credentialStore/kdbx/SecureString;)V", "", "title", "getTitle", "()Ljava/lang/String;", "setTitle", "(Ljava/lang/String;)V", "userName", "getUserName", "setUserName", "getOrCreatePropertyElement", "name", "getProperty", "propertyName", "setProperty", "touch", "", "intellij.platform.credentialStore"})
public final class KdbxEntry {
    @NotNull
    private final Element entryElement;
    private final KeePassDatabase database;
    @Nullable
    private volatile KdbxGroup group;

    @Nullable
    public final String getTitle() {
        return this.getProperty("Title");
    }

    public final void setTitle(@Nullable String value) {
        this.setProperty(this.entryElement, value, "Title");
    }

    @Nullable
    public final String getUserName() {
        return this.getProperty("UserName");
    }

    public final void setUserName(@Nullable String value) {
        this.setProperty(this.entryElement, value, "UserName");
    }

    private final synchronized String getProperty(String propertyName) {
        Element valueElement;
        Element element = KdbxEntryKt.access$getPropertyElement(this.entryElement, propertyName);
        Object object = valueElement = element != null ? element.getChild("Value") : null;
        if (valueElement == null) {
            return null;
        }
        String value = StringKt.nullize$default((String)valueElement.getText(), (boolean)false, (int)1, null);
        if (ProtectedValueKt.isValueProtected(valueElement)) {
            throw (Throwable)new UnsupportedOperationException(propertyName + " protection is not supported");
        }
        return value;
    }

    private final synchronized Element setProperty(Element entryElement, String value, String propertyName) {
        Element valueElement;
        String normalizedValue = StringKt.nullize$default((String)value, (boolean)false, (int)1, null);
        Element propertyElement = KdbxEntryKt.access$getPropertyElement(entryElement, propertyName);
        if (propertyElement == null) {
            if (normalizedValue == null) {
                return null;
            }
            propertyElement = KdbxEntryKt.access$createPropertyElement(entryElement, propertyName);
        }
        if (Intrinsics.areEqual((Object)StringKt.nullize$default((String)(valueElement = JdomKt.getOrCreate((Element)propertyElement, (String)"Value")).getText(), (boolean)false, (int)1, null), (Object)normalizedValue)) {
            return null;
        }
        valueElement.setText(value);
        if (entryElement == this.entryElement) {
            this.touch();
        }
        return valueElement;
    }

    @Nullable
    public final synchronized SecureString getPassword() {
        Element element = KdbxEntryKt.access$getPropertyElement(this.entryElement, "Password");
        if (element == null || (element = element.getChild("Value")) == null) {
            return null;
        }
        Element valueElement = element;
        Content content = (Content)CollectionsKt.firstOrNull((List)valueElement.getContent());
        if (content == null) {
            return null;
        }
        Content value = content;
        if (value instanceof SecureString) {
            return (SecureString)value;
        }
        valueElement.setAttribute("Protected", "True");
        UnsavedProtectedValue result = new UnsavedProtectedValue(this.database.protectValue$intellij_platform_credentialStore(value.getValue()));
        valueElement.setContent((Content)result);
        return result;
    }

    public final synchronized void setPassword(@Nullable SecureString value) {
        if (value == null) {
            Iterator iterator;
            Iterator iterator2 = iterator = this.entryElement.getChildren("String").iterator();
            boolean bl = false;
            Iterator iterator3 = iterator2;
            while (iterator3.hasNext()) {
                Element element = (Element)iterator3.next();
                if (!Intrinsics.areEqual((Object)element.getChildText("Key"), (Object)"Password")) continue;
                iterator.remove();
                this.touch();
            }
            return;
        }
        Element valueElement = JdomKt.getOrCreate((Element)this.getOrCreatePropertyElement("Password"), (String)"Value");
        valueElement.setAttribute("Protected", "True");
        Content oldValue = (Content)CollectionsKt.firstOrNull((List)valueElement.getContent());
        if (oldValue == value) {
            return;
        }
        valueElement.setContent((Content)new UnsavedProtectedValue((StringProtectedByStreamCipher)value));
        this.touch();
    }

    private final Element getOrCreatePropertyElement(String name) {
        Element element = KdbxEntryKt.access$getPropertyElement(this.entryElement, name);
        if (element == null) {
            element = KdbxEntryKt.access$createPropertyElement(this.entryElement, name);
        }
        return element;
    }

    private final synchronized void touch() {
        JdomKt.getOrCreate((Element)JdomKt.getOrCreate((Element)this.entryElement, (String)"Times"), (String)"LastModificationTime").setText(KeePassDatabaseKt.formattedNow());
        this.database.setDirty$intellij_platform_credentialStore(true);
    }

    @NotNull
    public final Element getEntryElement$intellij_platform_credentialStore() {
        return this.entryElement;
    }

    @Nullable
    public final KdbxGroup getGroup$intellij_platform_credentialStore() {
        return this.group;
    }

    public final void setGroup$intellij_platform_credentialStore(@Nullable KdbxGroup kdbxGroup) {
        this.group = kdbxGroup;
    }

    public KdbxEntry(@NotNull Element entryElement, @NotNull KeePassDatabase database, @Nullable KdbxGroup group) {
        this.entryElement = entryElement;
        this.database = database;
        this.group = group;
    }
}

