/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.facet;

import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.ui.FacetEditorContext;
import com.intellij.facet.ui.FacetEditorTab;
import com.intellij.facet.ui.FacetValidatorsManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import org.jetbrains.android.facet.AndroidFacetProperties;
import org.jetbrains.android.facet.AndroidImportableProperty;
import org.jetbrains.android.facet.NotEditableAndroidFacetEditorTab;
import org.jetbrains.annotations.NotNull;

public class AndroidFacetConfiguration
implements FacetConfiguration,
PersistentStateComponent<AndroidFacetProperties> {
    @NotNull
    private AndroidFacetProperties myProperties = new AndroidFacetProperties();

    public FacetEditorTab[] createEditorTabs(FacetEditorContext editorContext, FacetValidatorsManager validatorsManager) {
        EditorTabProvider editorTabProvider;
        AndroidFacetProperties state = this.getState();
        if (state.ALLOW_USER_CONFIGURATION && (editorTabProvider = (EditorTabProvider)ServiceManager.getService(EditorTabProvider.class)) != null) {
            return new FacetEditorTab[]{editorTabProvider.createFacetEditorTab(editorContext, this)};
        }
        return new FacetEditorTab[]{new NotEditableAndroidFacetEditorTab()};
    }

    public boolean isImportedProperty(@NotNull AndroidImportableProperty property) {
        return !this.myProperties.myNotImportedProperties.contains((Object)property);
    }

    public boolean isIncludeAssetsFromLibraries() {
        return this.myProperties.myIncludeAssetsFromLibraries;
    }

    public void setIncludeAssetsFromLibraries(boolean includeAssetsFromLibraries) {
        this.myProperties.myIncludeAssetsFromLibraries = includeAssetsFromLibraries;
    }

    public boolean isAppProject() {
        int projectType = this.getState().PROJECT_TYPE;
        return projectType == 0 || projectType == 4;
    }

    public boolean isAppOrFeature() {
        int projectType = this.getState().PROJECT_TYPE;
        return projectType == 0 || projectType == 4 || projectType == 5 || projectType == 6;
    }

    @NotNull
    public AndroidFacetProperties getState() {
        return this.myProperties;
    }

    public void loadState(@NotNull AndroidFacetProperties properties) {
        this.myProperties = properties;
    }

    public boolean canBeDependency() {
        int projectType = this.getState().PROJECT_TYPE;
        return projectType == 1 || projectType == 5;
    }

    public boolean isLibraryProject() {
        return this.getState().PROJECT_TYPE == 1;
    }

    public int getProjectType() {
        return this.getState().PROJECT_TYPE;
    }

    public void setProjectType(int type) {
        this.getState().PROJECT_TYPE = type;
    }

    static interface EditorTabProvider {
        public FacetEditorTab createFacetEditorTab(@NotNull FacetEditorContext var1, @NotNull AndroidFacetConfiguration var2);
    }
}

