/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.util;

import com.intellij.execution.CommandLineUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.PathExecLazyValue;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u001e\u001a\u00020\tH\u0002J \u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00132\u0006\u0010\"\u001a\u00020\u00132\u0006\u0010#\u001a\u00020\u0013H\u0007J\u0016\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00130%2\u0006\u0010&\u001a\u00020'H\u0002J\u0016\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00130%2\u0006\u0010&\u001a\u00020'H\u0002J\u0010\u0010)\u001a\u00020\u00132\u0006\u0010*\u001a\u00020\u0013H\u0002J\u0010\u0010+\u001a\u00020\u00132\u0006\u0010*\u001a\u00020\u0013H\u0007J\u0010\u0010,\u001a\u00020-2\u0006\u0010&\u001a\u00020'H\u0007J\u0018\u0010,\u001a\u00020-2\u0006\u0010&\u001a\u00020'2\u0006\u0010.\u001a\u00020/H\u0007J \u0010,\u001a\u00020-2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u00130%2\b\u00101\u001a\u0004\u0018\u00010\u0013H\u0007J\u0012\u00102\u001a\u0004\u0018\u00010\u00132\u0006\u0010&\u001a\u00020'H\u0007J \u00103\u001a\b\u0012\u0004\u0012\u00020\u00130%2\b\u00104\u001a\u0004\u0018\u00010\u00132\u0006\u00100\u001a\u00020\u0013H\u0007J\b\u00105\u001a\u00020\tH\u0007J.\u00106\u001a\u00020\u00132\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020\u00132\u0014\u0010:\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0013\u0018\u00010;H\u0007J\u001c\u0010<\u001a\u0004\u0018\u00010\u00132\u0006\u0010=\u001a\u00020>2\b\u0010?\u001a\u0004\u0018\u00010@H\u0007J\u0010\u0010A\u001a\u00020B2\u0006\u0010&\u001a\u00020'H\u0007J\u0010\u0010C\u001a\u00020B2\u0006\u0010&\u001a\u00020'H\u0007J\u0018\u0010D\u001a\u00020E2\u0006\u0010&\u001a\u00020'2\u0006\u0010F\u001a\u00020\u0013H\u0007J\u0018\u0010G\u001a\u00020-2\u0006\u0010&\u001a\u00020'2\u0006\u0010F\u001a\u00020\u0013H\u0007J\u0018\u0010H\u001a\u00020'2\u0006\u0010&\u001a\u00020'2\u0006\u0010F\u001a\u00020\u0013H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\b\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u000e\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u00020\u00138FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0015\u0010\u0002\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u00138FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0019\u0010\u0002\u001a\u0004\b\u001a\u0010\u0017R\u001a\u0010\u001b\u001a\u00020\u00138FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u001c\u0010\u0002\u001a\u0004\b\u001d\u0010\u0017\u00a8\u0006I"}, d2={"Lcom/intellij/execution/util/ExecUtil;", "", "()V", "hasGkSudo", "Lcom/intellij/openapi/util/io/PathExecLazyValue;", "hasGnomeTerminal", "hasKdeSudo", "hasKdeTerminal", "hasNice", "", "getHasNice", "()Z", "hasNice$delegate", "Lkotlin/Lazy;", "hasPkExec", "hasSetsid", "hasUrxvt", "hasXTerm", "nicePath", "", "openCommandPath", "getOpenCommandPath$annotations", "getOpenCommandPath", "()Ljava/lang/String;", "osascriptPath", "getOsascriptPath$annotations", "getOsascriptPath", "windowsShellName", "getWindowsShellName$annotations", "getWindowsShellName", "canRunLowPriority", "createTempExecutableScript", "Ljava/io/File;", "prefix", "suffix", "content", "envCommand", "", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "envCommandArgs", "escapeAppleScriptArgument", "arg", "escapeUnixShellArgument", "execAndGetOutput", "Lcom/intellij/execution/process/ProcessOutput;", "timeoutInMilliseconds", "", "command", "workDir", "execAndReadLine", "getTerminalCommand", "title", "hasTerminalApp", "loadTemplate", "loader", "Ljava/lang/ClassLoader;", "templateName", "variables", "", "readFirstLine", "stream", "Ljava/io/InputStream;", "cs", "Ljava/nio/charset/Charset;", "setupLowPriorityExecution", "", "setupNoTtyExecution", "sudo", "Ljava/lang/Process;", "prompt", "sudoAndGetOutput", "sudoCommand", "intellij.platform.ide.util.io"})
public final class ExecUtil {
    private static final PathExecLazyValue hasGkSudo;
    private static final PathExecLazyValue hasKdeSudo;
    private static final PathExecLazyValue hasPkExec;
    private static final PathExecLazyValue hasGnomeTerminal;
    private static final PathExecLazyValue hasKdeTerminal;
    private static final PathExecLazyValue hasUrxvt;
    private static final PathExecLazyValue hasXTerm;
    private static final PathExecLazyValue hasSetsid;
    private static final String nicePath = "/usr/bin/nice";
    private static final Lazy hasNice$delegate;
    public static final ExecUtil INSTANCE;

    private final boolean getHasNice() {
        Lazy lazy = hasNice$delegate;
        ExecUtil execUtil = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Boolean)lazy.getValue();
    }

    @JvmStatic
    public static /* synthetic */ void getOsascriptPath$annotations() {
    }

    @NotNull
    public static final String getOsascriptPath() {
        return "/usr/bin/osascript";
    }

    @JvmStatic
    public static /* synthetic */ void getOpenCommandPath$annotations() {
    }

    @NotNull
    public static final String getOpenCommandPath() {
        return "/usr/bin/open";
    }

    @JvmStatic
    public static /* synthetic */ void getWindowsShellName$annotations() {
    }

    @NotNull
    public static final String getWindowsShellName() {
        return CommandLineUtil.getWinShellName();
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final String loadTemplate(@NotNull ClassLoader loader, @NotNull String templateName, @Nullable Map<String, String> variables) throws IOException {
        InputStream inputStream = loader.getResourceAsStream(templateName);
        if (inputStream == null) {
            throw (Throwable)new IOException("Template '" + templateName + "' not found by " + loader);
        }
        InputStream stream = inputStream;
        String template = FileUtil.loadTextAndClose((Reader)new InputStreamReader(stream, Charsets.UTF_8));
        if (variables == null || variables.isEmpty()) {
            return template;
        }
        StringBuilder buffer = new StringBuilder(template);
        Object object = variables;
        boolean bl = false;
        Iterator<Map.Entry<String, String>> iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            void name;
            Map.Entry<String, String> entry;
            Map.Entry<String, String> entry2 = entry = iterator.next();
            boolean bl2 = false;
            object = entry2.getKey();
            entry2 = entry;
            bl2 = false;
            String value = entry2.getValue();
            int pos = buffer.indexOf((String)name);
            if (pos < 0) continue;
            buffer.replace(pos, pos + name.length(), value);
        }
        return buffer.toString();
    }

    @JvmStatic
    @NotNull
    public static final File createTempExecutableScript(@NotNull String prefix, @NotNull String suffix, @NotNull String content) throws IOException, ExecutionException {
        File tempDir = new File(PathManager.getTempPath());
        File tempFile = FileUtil.createTempFile((File)tempDir, (String)prefix, (String)suffix, (boolean)true, (boolean)true);
        String string = content;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        FileUtil.writeToFile((File)tempFile, (byte[])byArray);
        if (!tempFile.setExecutable(true, true)) {
            throw (Throwable)new ExecutionException("Failed to make temp file executable: " + tempFile);
        }
        return tempFile;
    }

    @JvmStatic
    @NotNull
    public static final ProcessOutput execAndGetOutput(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
        return new CapturingProcessHandler(commandLine).runProcess();
    }

    @JvmStatic
    @NotNull
    public static final ProcessOutput execAndGetOutput(@NotNull GeneralCommandLine commandLine, int timeoutInMilliseconds) throws ExecutionException {
        return new CapturingProcessHandler(commandLine).runProcess(timeoutInMilliseconds);
    }

    @JvmStatic
    @Nullable
    public static final String execAndReadLine(@NotNull GeneralCommandLine commandLine) {
        String string;
        try {
            string = ExecUtil.readFirstLine(commandLine.createProcess().getInputStream(), commandLine.getCharset());
        }
        catch (ExecutionException e) {
            Logger.getInstance(ExecUtil.class).debug((Throwable)e);
            string = null;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @Nullable
    public static final String readFirstLine(@NotNull InputStream stream, @Nullable Charset cs) {
        Object object;
        try {
            String string;
            object = new BufferedReader(cs == null ? new InputStreamReader(stream) : new InputStreamReader(stream, cs));
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                BufferedReader it = (BufferedReader)object;
                boolean bl3 = false;
                string = it.readLine();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            object = string;
        }
        catch (IOException e) {
            Logger.getInstance(ExecUtil.class).debug((Throwable)e);
            object = null;
        }
        return object;
    }

    @JvmStatic
    @NotNull
    public static final Process sudo(@NotNull GeneralCommandLine commandLine, @NotNull String prompt) throws ExecutionException, IOException {
        return ExecUtil.sudoCommand(commandLine, prompt).createProcess();
    }

    @JvmStatic
    @NotNull
    public static final GeneralCommandLine sudoCommand(@NotNull GeneralCommandLine commandLine, @NotNull String prompt) throws ExecutionException, IOException {
        GeneralCommandLine generalCommandLine;
        if (SystemInfo.isUnix && Intrinsics.areEqual((Object)"root", (Object)System.getenv("USER"))) {
            return commandLine;
        }
        List command = CollectionsKt.mutableListOf((Object[])new String[]{commandLine.getExePath()});
        Collection collection = command;
        Iterable iterable = commandLine.getParametersList().getList();
        boolean bl = false;
        CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
        if (SystemInfo.isWinVistaOrNewer) {
            Path launcherExe = PathManager.findBinFileWithException((String)"launcher.exe");
            generalCommandLine = new GeneralCommandLine(CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])new String[]{((Object)launcherExe).toString(), commandLine.getExePath()}), (Iterable)commandLine.getParametersList().getParameters()));
        } else {
            if (SystemInfo.isWindows) {
                throw (Throwable)new UnsupportedOperationException("Executing as Administrator is only available in Windows Vista or newer");
            }
            if (SystemInfo.isMac) {
                String escapedCommand2 = StringUtil.join((Collection)command, (Function)sudoCommand.sudoCommandLine.escapedCommand.1.INSTANCE, (String)" & \" \" & ");
                String messageArg = SystemInfo.isMacOSYosemite ? " with prompt \"" + StringUtil.escapeQuotes((String)prompt) + '\"' : "";
                String escapedScript = "tell current application\n   activate\n" + "   do shell script " + escapedCommand2 + messageArg + " with administrator privileges without altering line endings\n" + "end tell";
                generalCommandLine = new GeneralCommandLine(ExecUtil.getOsascriptPath(), "-e", escapedScript);
            } else if (((Boolean)hasGkSudo.getValue()).booleanValue()) {
                generalCommandLine = new GeneralCommandLine(CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])new String[]{"gksudo", "--message", prompt, "--"}), (Iterable)INSTANCE.envCommand(commandLine)), (Iterable)command));
            } else if (((Boolean)hasKdeSudo.getValue()).booleanValue()) {
                generalCommandLine = new GeneralCommandLine(CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])new String[]{"kdesudo", "--comment", prompt, "--"}), (Iterable)INSTANCE.envCommand(commandLine)), (Iterable)command));
            } else if (((Boolean)hasPkExec.getValue()).booleanValue()) {
                generalCommandLine = new GeneralCommandLine(CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)"pkexec"), (Iterable)INSTANCE.envCommand(commandLine)), (Iterable)command));
            } else if (ExecUtil.hasTerminalApp()) {
                String escapedCommandLine2 = StringUtil.join((Collection)command, (Function)sudoCommand.sudoCommandLine.escapedCommandLine.1.INSTANCE, (String)" ");
                List<String> args = INSTANCE.envCommandArgs(commandLine);
                String escapedEnvCommand2 = Intrinsics.areEqual(args, (Object)CollectionsKt.emptyList()) ? "" : "env " + StringUtil.join((Collection)args, (Function)sudoCommand.sudoCommandLine.escapedEnvCommand.1.INSTANCE, (String)" ") + " ";
                File script = ExecUtil.createTempExecutableScript("sudo", ".sh", "#!/bin/sh\necho " + ExecUtil.escapeUnixShellArgument(prompt) + "\n" + "echo\n" + "sudo -- " + escapedEnvCommand2 + escapedCommandLine2 + "\n" + "STATUS=$?\n" + "echo\n" + "read -p \"Press Enter to close this window...\" TEMP\n" + "exit $STATUS\n");
                generalCommandLine = new GeneralCommandLine(ExecUtil.getTerminalCommand("Install", script.getAbsolutePath()));
            } else {
                throw (Throwable)new UnsupportedOperationException("Cannot `sudo` on this system - no suitable utils found");
            }
        }
        GeneralCommandLine sudoCommandLine2 = generalCommandLine;
        return sudoCommandLine2.withWorkDirectory(commandLine.getWorkDirectory()).withEnvironment(commandLine.getEnvironment()).withParentEnvironmentType(commandLine.getParentEnvironmentType()).withRedirectErrorStream(commandLine.isRedirectErrorStream());
    }

    private final List<String> envCommand(GeneralCommandLine commandLine) {
        List<String> args = this.envCommandArgs(commandLine);
        return Intrinsics.areEqual(args, (Object)CollectionsKt.emptyList()) ? CollectionsKt.emptyList() : CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)"env"), (Iterable)args);
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> envCommandArgs(GeneralCommandLine commandLine) {
        List list;
        Map<String, String> env = commandLine.getEnvironment();
        if (Intrinsics.areEqual(env, (Object)MapsKt.emptyMap())) {
            list = CollectionsKt.emptyList();
        } else {
            void $this$mapTo$iv$iv;
            Map<String, String> $this$map$iv = env;
            boolean $i$f$map = false;
            Map<String, String> map = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            void var8_8 = $this$mapTo$iv$iv;
            boolean bl = false;
            Iterator iterator = var8_8.entrySet().iterator();
            while (iterator.hasNext()) {
                void entry;
                Map.Entry item$iv$iv;
                Map.Entry entry2 = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                String string = (String)entry.getKey() + '=' + (String)entry.getValue();
                collection.add(string);
            }
            list = (List)destination$iv$iv;
        }
        return list;
    }

    @JvmStatic
    @NotNull
    public static final ProcessOutput sudoAndGetOutput(@NotNull GeneralCommandLine commandLine, @NotNull String prompt) throws IOException, ExecutionException {
        return ExecUtil.execAndGetOutput(ExecUtil.sudoCommand(commandLine, prompt));
    }

    private final String escapeAppleScriptArgument(String arg) {
        return "quoted form of \"" + StringsKt.replace$default((String)arg, (String)"\"", (String)"\\\"", (boolean)false, (int)4, null) + '\"';
    }

    @JvmStatic
    @NotNull
    public static final String escapeUnixShellArgument(@NotNull String arg) {
        return '\'' + StringsKt.replace$default((String)arg, (String)"'", (String)"'\"'\"'", (boolean)false, (int)4, null) + '\'';
    }

    @JvmStatic
    public static final boolean hasTerminalApp() {
        return SystemInfo.isWindows || SystemInfo.isMac || (Boolean)hasKdeTerminal.getValue() != false || (Boolean)hasGnomeTerminal.getValue() != false || (Boolean)hasUrxvt.getValue() != false || (Boolean)hasXTerm.getValue() != false;
    }

    @JvmStatic
    @NotNull
    public static final List<String> getTerminalCommand(@Nullable String title, @NotNull String command) {
        List list;
        if (SystemInfo.isWindows) {
            Object[] objectArray = new String[5];
            objectArray[0] = ExecUtil.getWindowsShellName();
            objectArray[1] = "/c";
            objectArray[2] = "start";
            String string = title;
            if (string == null || (string = StringsKt.replace$default((String)string, (char)'\"', (char)'\'', (boolean)false, (int)4, null)) == null) {
                string = "";
            }
            objectArray[3] = GeneralCommandLine.inescapableQuote(string);
            objectArray[4] = command;
            list = CollectionsKt.listOf((Object[])objectArray);
        } else if (SystemInfo.isMac) {
            list = CollectionsKt.listOf((Object[])new String[]{ExecUtil.getOpenCommandPath(), "-a", "Terminal", command});
        } else if (((Boolean)hasKdeTerminal.getValue()).booleanValue()) {
            list = title != null ? CollectionsKt.listOf((Object[])new String[]{"konsole", "-p", "tabtitle=\"" + StringsKt.replace$default((String)title, (char)'\"', (char)'\'', (boolean)false, (int)4, null) + '\"', "-e", command}) : CollectionsKt.listOf((Object[])new String[]{"konsole", "-e", command});
        } else if (((Boolean)hasGnomeTerminal.getValue()).booleanValue()) {
            list = title != null ? CollectionsKt.listOf((Object[])new String[]{"gnome-terminal", "-t", title, "-x", command}) : CollectionsKt.listOf((Object[])new String[]{"gnome-terminal", "-x", command});
        } else if (((Boolean)hasUrxvt.getValue()).booleanValue()) {
            list = title != null ? CollectionsKt.listOf((Object[])new String[]{"urxvt", "-title", title, "-e", command}) : CollectionsKt.listOf((Object[])new String[]{"urxvt", "-e", command});
        } else if (((Boolean)hasXTerm.getValue()).booleanValue()) {
            list = title != null ? CollectionsKt.listOf((Object[])new String[]{"xterm", "-T", title, "-e", command}) : CollectionsKt.listOf((Object[])new String[]{"xterm", "-e", command});
        } else {
            throw (Throwable)new UnsupportedOperationException("Unsupported OS/desktop: " + SystemInfo.OS_NAME + '/' + System.getenv("XDG_CURRENT_DESKTOP"));
        }
        return list;
    }

    @JvmStatic
    public static final void setupLowPriorityExecution(@NotNull GeneralCommandLine commandLine) {
        if (INSTANCE.canRunLowPriority()) {
            String executablePath = commandLine.getExePath();
            if (SystemInfo.isWindows) {
                commandLine.setExePath(ExecUtil.getWindowsShellName());
                commandLine.getParametersList().prependAll("/c", "start", "/b", "/low", "/wait", GeneralCommandLine.inescapableQuote(""), executablePath);
            } else {
                commandLine.setExePath(nicePath);
                commandLine.getParametersList().prependAll("-n", "10", executablePath);
            }
        }
    }

    private final boolean canRunLowPriority() {
        return Registry.is((String)"ide.allow.low.priority.process") && (SystemInfo.isWindows || this.getHasNice());
    }

    @JvmStatic
    public static final void setupNoTtyExecution(@NotNull GeneralCommandLine commandLine) {
        if (SystemInfo.isLinux && ((Boolean)hasSetsid.getValue()).booleanValue()) {
            String executablePath = commandLine.getExePath();
            commandLine.setExePath("setsid");
            commandLine.getParametersList().prependAll(executablePath);
        }
    }

    @Deprecated(message="use {@link #execAndGetOutput(GeneralCommandLine)} instead")
    @JvmStatic
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    @NotNull
    public static final ProcessOutput execAndGetOutput(@NotNull List<String> command, @Nullable String workDir) throws ExecutionException {
        GeneralCommandLine commandLine = new GeneralCommandLine(command).withWorkDirectory(workDir);
        return new CapturingProcessHandler(commandLine).runProcess();
    }

    private ExecUtil() {
    }

    static {
        ExecUtil execUtil;
        INSTANCE = execUtil = new ExecUtil();
        hasGkSudo = new PathExecLazyValue("gksudo");
        hasKdeSudo = new PathExecLazyValue("kdesudo");
        hasPkExec = new PathExecLazyValue("pkexec");
        hasGnomeTerminal = new PathExecLazyValue("gnome-terminal");
        hasKdeTerminal = new PathExecLazyValue("konsole");
        hasUrxvt = new PathExecLazyValue("urxvt");
        hasXTerm = new PathExecLazyValue("xterm");
        hasSetsid = new PathExecLazyValue("setsid");
        hasNice$delegate = LazyKt.lazy((Function0)hasNice.2.INSTANCE);
    }

    public static final /* synthetic */ String access$escapeAppleScriptArgument(ExecUtil $this, String arg) {
        return $this.escapeAppleScriptArgument(arg);
    }
}

