/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.plugins.idea;

import androidx.compose.plugins.idea.ComposableCallCheckerKt;
import androidx.compose.plugins.idea.ComposePluginUtilsKt;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analyzer.AnalysisResult;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\rH\u0002\u00a8\u0006\u000f"}, d2={"Landroidx/compose/plugins/idea/ComposableAnnotator;", "Lcom/intellij/lang/annotation/Annotator;", "()V", "annotate", "", "element", "Lcom/intellij/psi/PsiElement;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "shouldStyleCall", "", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "TextAttributeRegistry", "intellij.android.compose-ide-plugin"})
public final class ComposableAnnotator
implements Annotator {
    @NotNull
    private static final TextAttributesKey COMPOSABLE_CALL_TEXT_ATTRIBUTES_KEY;
    @NotNull
    private static final String COMPOSABLE_CALL_TEXT_ATTRIBUTES_NAME = "ComposableCallTextAttributes";
    private static final Key<AnalysisResult> ANALYSIS_RESULT_KEY;
    public static final TextAttributeRegistry TextAttributeRegistry;

    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        if (!(element instanceof KtCallExpression)) {
            return;
        }
        if (!ComposePluginUtilsKt.isComposeEnabled(element)) {
            return;
        }
        AnalysisResult analysisResult = (AnalysisResult)holder.getCurrentAnnotationSession().getUserData(ANALYSIS_RESULT_KEY);
        if (analysisResult == null) {
            PsiFile psiFile = ((KtCallExpression)element).getContainingFile();
            if (!(psiFile instanceof KtFile)) {
                psiFile = null;
            }
            KtFile ktFile = (KtFile)psiFile;
            if (ktFile == null) {
                return;
            }
            KtFile ktFile2 = ktFile;
            analysisResult = ResolutionUtils.analyzeWithAllCompilerChecks((KtFile)ktFile2, (KtFile[])new KtFile[0]);
            holder.getCurrentAnnotationSession().putUserData(ANALYSIS_RESULT_KEY, (Object)analysisResult);
        }
        if (analysisResult.isError()) {
            throw (Throwable)new ProcessCanceledException(analysisResult.getError());
        }
        if (!this.shouldStyleCall(analysisResult.getBindingContext(), (KtCallExpression)element)) {
            return;
        }
        KtExpression ktExpression = ((KtCallExpression)element).getCalleeExpression();
        if (ktExpression == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"element.calleeExpression ?: return");
        KtExpression elementToStyle = ktExpression;
        Annotation annotation = holder.createInfoAnnotation(elementToStyle.getTextRange(), null);
        Intrinsics.checkExpressionValueIsNotNull((Object)annotation, (String)"holder.createInfoAnnotat\u2026tToStyle.textRange, null)");
        Annotation annotation2 = annotation;
        annotation2.setTextAttributes(COMPOSABLE_CALL_TEXT_ATTRIBUTES_KEY);
    }

    private final boolean shouldStyleCall(BindingContext bindingContext, KtCallExpression element) {
        ResolvedCall resolvedCall = CallUtilKt.getResolvedCall((KtElement)((KtElement)element), (BindingContext)bindingContext);
        return resolvedCall != null && ComposableCallCheckerKt.isComposableInvocation(resolvedCall);
    }

    static {
        TextAttributeRegistry = new TextAttributeRegistry(null);
        COMPOSABLE_CALL_TEXT_ATTRIBUTES_NAME = COMPOSABLE_CALL_TEXT_ATTRIBUTES_NAME;
        ANALYSIS_RESULT_KEY = new Key("IdeComposableAnnotator.DidAnnotateKey");
        TextAttributesKey textAttributesKey = TextAttributesKey.createTextAttributesKey((String)COMPOSABLE_CALL_TEXT_ATTRIBUTES_NAME, (TextAttributesKey)DefaultLanguageHighlighterColors.FUNCTION_CALL);
        Intrinsics.checkExpressionValueIsNotNull((Object)textAttributesKey, (String)"TextAttributesKey.create\u2026hterColors.FUNCTION_CALL)");
        COMPOSABLE_CALL_TEXT_ATTRIBUTES_KEY = textAttributesKey;
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Landroidx/compose/plugins/idea/ComposableAnnotator$TextAttributeRegistry;", "", "()V", "ANALYSIS_RESULT_KEY", "Lcom/intellij/openapi/util/Key;", "Lorg/jetbrains/kotlin/analyzer/AnalysisResult;", "COMPOSABLE_CALL_TEXT_ATTRIBUTES_KEY", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "getCOMPOSABLE_CALL_TEXT_ATTRIBUTES_KEY", "()Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "COMPOSABLE_CALL_TEXT_ATTRIBUTES_NAME", "", "getCOMPOSABLE_CALL_TEXT_ATTRIBUTES_NAME", "()Ljava/lang/String;", "intellij.android.compose-ide-plugin"})
    public static final class TextAttributeRegistry {
        @NotNull
        public final TextAttributesKey getCOMPOSABLE_CALL_TEXT_ATTRIBUTES_KEY() {
            return COMPOSABLE_CALL_TEXT_ATTRIBUTES_KEY;
        }

        @NotNull
        public final String getCOMPOSABLE_CALL_TEXT_ATTRIBUTES_NAME() {
            return COMPOSABLE_CALL_TEXT_ATTRIBUTES_NAME;
        }

        private TextAttributeRegistry() {
        }

        public /* synthetic */ TextAttributeRegistry(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

