/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.util;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Set;
import java.util.stream.Stream;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JpsPathUtil {
    public static final String UNNAMED_PROJECT = "<unnamed>";

    public static boolean isUnder(Set<File> ancestors, File file) {
        if (ancestors.isEmpty()) {
            return false;
        }
        File current = file;
        while (current != null) {
            if (ancestors.contains(current)) {
                return true;
            }
            current = FileUtilRt.getParentFile((File)current);
        }
        return false;
    }

    public static File urlToFile(String url) {
        return new File(JpsPathUtil.urlToOsPath(url));
    }

    @NotNull
    public static String urlToOsPath(@NotNull String url) {
        return FileUtilRt.toSystemDependentName((String)JpsPathUtil.urlToPath(url));
    }

    @Contract(value="null -> null; !null -> !null")
    public static String urlToPath(@Nullable String url) {
        if (url == null) {
            return null;
        }
        if (url.startsWith("file://")) {
            return url.substring("file://".length());
        }
        if (url.startsWith("jar://")) {
            url = url.substring("jar://".length());
            url = StringUtil.trimEnd((String)url, (String)"!/");
        }
        return url;
    }

    @NotNull
    public static String fixURLforIDEA(@NotNull String url) {
        int idx = url.indexOf(":/");
        if (idx >= 0 && idx + 2 < url.length() && url.charAt(idx + 2) != '/') {
            String prefix = url.substring(0, idx);
            String suffix = url.substring(idx + 2);
            url = SystemInfo.isWindows ? prefix + "://" + suffix : prefix + ":///" + suffix;
        }
        return url;
    }

    public static String pathToUrl(String path2) {
        return "file://" + path2;
    }

    public static String getLibraryRootUrl(File file) {
        String path2 = FileUtilRt.toSystemIndependentName((String)file.getAbsolutePath());
        return file.isDirectory() ? "file://" + path2 : "jar://" + path2 + "!/";
    }

    public static boolean isJrtUrl(@NotNull String url) {
        return url.startsWith("jrt://");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static String readProjectName(@NotNull Path projectDir) {
        try (Stream<String> stream = Files.lines(projectDir.resolve(".name"));){
            String string = stream.findFirst().map(String::trim).orElse(null);
            return string;
        }
        catch (IOException | UncheckedIOException e) {
            return null;
        }
    }

    @NotNull
    public static String getDefaultProjectName(@NotNull Path projectDir) {
        Path parent = projectDir.getParent();
        if (parent != null) {
            Path name = parent.getFileName();
            return name != null ? name.toString() : parent.toString();
        }
        return UNNAMED_PROJECT;
    }
}

