/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.java;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.ex.JpsElementBase;

public class JavaResourceRootProperties
extends JpsElementBase<JavaResourceRootProperties> {
    private String myRelativeOutputPath = "";
    private boolean myForGeneratedSources;

    public JavaResourceRootProperties(@NotNull String relativeOutputPath, boolean forGeneratedSources) {
        this.myRelativeOutputPath = relativeOutputPath;
        this.myForGeneratedSources = forGeneratedSources;
    }

    @NotNull
    public String getRelativeOutputPath() {
        return this.myRelativeOutputPath;
    }

    @Override
    @NotNull
    public JavaResourceRootProperties createCopy() {
        return new JavaResourceRootProperties(this.myRelativeOutputPath, this.myForGeneratedSources);
    }

    public boolean isForGeneratedSources() {
        return this.myForGeneratedSources;
    }

    public void setRelativeOutputPath(@NotNull String relativeOutputPath) {
        if (!Objects.equals(this.myRelativeOutputPath, relativeOutputPath)) {
            this.myRelativeOutputPath = relativeOutputPath;
            this.fireElementChanged();
        }
    }

    public void setForGeneratedSources(boolean forGeneratedSources) {
        if (this.myForGeneratedSources != forGeneratedSources) {
            this.myForGeneratedSources = forGeneratedSources;
            this.fireElementChanged();
        }
    }

    @Override
    public void applyChanges(@NotNull JavaResourceRootProperties modified) {
        this.setRelativeOutputPath(modified.myRelativeOutputPath);
        this.setForGeneratedSources(modified.myForGeneratedSources);
    }
}

