/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.text.DateTimeFormatManager;
import com.intellij.util.text.JBDateTimeFormatter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.jetbrains.annotations.NotNull;

public class CustomJBDateTimeFormatter
extends JBDateTimeFormatter {
    @NotNull
    private final DateFormat myDateFormat;
    @NotNull
    private final DateFormat myDateTimeFormat;
    @NotNull
    private final DateFormat myDateTimeSecondsFormat;

    public CustomJBDateTimeFormatter(@NotNull String pattern, boolean use24hour) {
        this.myDateFormat = new SimpleDateFormat(pattern);
        this.myDateTimeFormat = new SimpleDateFormat(pattern + ", " + (use24hour ? "HH:mm" : "h:mm a"));
        this.myDateTimeSecondsFormat = new SimpleDateFormat(pattern + ", " + (use24hour ? "HH:mm:ss" : "h:mm:ss a"));
    }

    @NotNull
    protected DateFormat getFormat() {
        return this.myDateFormat;
    }

    @NotNull
    protected DateFormat getDateTimeFormat() {
        return this.myDateTimeFormat;
    }

    @NotNull
    protected DateFormat getDateTimeSecondsFormat() {
        return this.myDateTimeSecondsFormat;
    }

    @Override
    protected boolean isPrettyFormattingSupported() {
        return false;
    }

    @Override
    @NotNull
    public String formatTime(long time) {
        return this.getDateTimeFormat().format(new Date(time));
    }

    @Override
    @NotNull
    public String formatTimeWithSeconds(long time) {
        return this.getDateTimeSecondsFormat().format(time);
    }

    @Override
    @NotNull
    public String formatDate(long time) {
        return this.getFormat().format(time);
    }

    @Override
    @NotNull
    public String formatPrettyDateTime(long time) {
        if (DateTimeFormatManager.getInstance().isPrettyFormattingAllowed() && DateFormatUtil.isPrettyFormattingPossible((long)time)) {
            return DateFormatUtil.formatPrettyDateTime((long)time);
        }
        return this.formatTime(time);
    }

    @Override
    @NotNull
    public String formatPrettyDate(long time) {
        if (DateTimeFormatManager.getInstance().isPrettyFormattingAllowed() && DateFormatUtil.isPrettyFormattingPossible((long)time)) {
            return DateFormatUtil.formatPrettyDate((long)time);
        }
        return this.formatDate(time);
    }

    @Override
    @NotNull
    public String formatDateTime(Date date) {
        return this.formatTime(date);
    }

    @Override
    @NotNull
    public String formatDateTime(long time) {
        return this.formatTime(time);
    }

    @Override
    @NotNull
    public String formatPrettyDateTime(@NotNull Date date) {
        return this.formatPrettyDateTime(date.getTime());
    }

    @Override
    @NotNull
    public String formatPrettyDate(@NotNull Date date) {
        return this.formatPrettyDate(date.getTime());
    }
}

