/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.net.ssl;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.net.ssl.ConfirmingTrustManager;
import com.intellij.util.net.ssl.UntrustedCertificateStrategy;
import com.intellij.util.xmlb.XmlSerializerUtil;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.crypto.BadPaddingException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="CertificateManager", storages={@Storage(value="certificates.xml")}, reportStatistic=false)
public final class CertificateManager
implements PersistentStateComponent<Config> {
    @NonNls
    public static final String COMPONENT_NAME = "Certificate Manager";
    @NonNls
    public static final String DEFAULT_PATH = FileUtil.join((String[])new String[]{PathManager.getConfigPath(), "ssl", "cacerts"});
    @NonNls
    public static final String DEFAULT_PASSWORD = "changeit";
    private static final Logger LOG = Logger.getInstance(CertificateManager.class);
    static final long DIALOG_VISIBILITY_TIMEOUT = 5000L;
    private final Config myConfig = new Config();
    private final AtomicNotNullLazyValue<ConfirmingTrustManager> myTrustManager = AtomicNotNullLazyValue.createValue(() -> ConfirmingTrustManager.createForStorage(CertificateManager.tryMigratingDefaultTruststore(), DEFAULT_PASSWORD));
    private final AtomicNotNullLazyValue<SSLContext> mySslContext = AtomicNotNullLazyValue.createValue(() -> this.calcSslContext());

    public static CertificateManager getInstance() {
        return (CertificateManager)ApplicationManager.getApplication().getService(CertificateManager.class);
    }

    @NotNull
    private static String tryMigratingDefaultTruststore() {
        Path legacySystemPath = Paths.get(PathManager.getSystemPath(), "tasks", "cacerts");
        Path configPath = Paths.get(DEFAULT_PATH, new String[0]);
        if (!Files.exists(configPath, new LinkOption[0]) && Files.exists(legacySystemPath, new LinkOption[0])) {
            LOG.info("Migrating the default truststore from " + legacySystemPath + " to " + configPath);
            try {
                Files.createDirectories(configPath.getParent(), new FileAttribute[0]);
                try {
                    Files.move(legacySystemPath, configPath, new CopyOption[0]);
                }
                catch (FileAlreadyExistsException | NoSuchFileException fileSystemException) {}
            }
            catch (IOException e) {
                LOG.error("Cannot move the default truststore from " + legacySystemPath + " to " + configPath, (Throwable)e);
                return legacySystemPath.toString();
            }
        }
        return DEFAULT_PATH;
    }

    public CertificateManager() {
        AppExecutorUtil.getAppExecutorService().execute(() -> {
            try {
                SSLContext.setDefault(this.getSslContext());
                LOG.info("Default SSL context initialized");
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        });
    }

    @NotNull
    public synchronized SSLContext getSslContext() {
        return (SSLContext)this.mySslContext.getValue();
    }

    @NotNull
    private SSLContext calcSslContext() {
        SSLContext context = CertificateManager.getSystemSslContext();
        try {
            context.init(CertificateManager.getDefaultKeyManagers(), new TrustManager[]{this.getTrustManager()}, null);
        }
        catch (KeyManagementException e) {
            LOG.error((Throwable)e);
        }
        return context;
    }

    @NotNull
    public static SSLContext getSystemSslContext() {
        try {
            SSLContext context = SSLContext.getInstance("TLS");
            context.init(null, null, null);
            return context;
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error((Throwable)e);
            throw new AssertionError((Object)"Cannot get system SSL context");
        }
        catch (KeyManagementException e) {
            LOG.error((Throwable)e);
            throw new AssertionError((Object)"Cannot initialize system SSL context");
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static KeyManager @Nullable [] getDefaultKeyManagers() {
        String keyStorePath = System.getProperty("javax.net.ssl.keyStore");
        if (keyStorePath == null) return null;
        LOG.info("Loading custom key store specified with VM options: " + keyStorePath);
        try {
            KeyStore keyStore;
            KeyManagerFactory factory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            String keyStoreType = System.getProperty("javax.net.ssl.keyStoreType", KeyStore.getDefaultType());
            try {
                keyStore = KeyStore.getInstance(keyStoreType);
            }
            catch (KeyStoreException e) {
                if (!(e.getCause() instanceof NoSuchAlgorithmException)) throw e;
                LOG.error("Wrong key store type: " + keyStoreType, (Throwable)e);
                return null;
            }
            String password = System.getProperty("javax.net.ssl.keyStorePassword", "");
            FileInputStream inputStream = null;
            try {
                inputStream = new FileInputStream(keyStorePath);
                keyStore.load(inputStream, password.toCharArray());
                factory.init(keyStore, password.toCharArray());
            }
            catch (FileNotFoundException e) {
                LOG.error("Key store file not found: " + keyStorePath);
                KeyManager[] keyManagerArray = null;
                {
                    catch (Throwable throwable) {
                        StreamUtil.closeStream(inputStream);
                        throw throwable;
                    }
                }
                StreamUtil.closeStream((Closeable)inputStream);
                return keyManagerArray;
                catch (Exception e2) {
                    block11: {
                        if (!(e2.getCause() instanceof BadPaddingException)) break block11;
                        LOG.error("Wrong key store password: " + password, (Throwable)e2);
                        KeyManager[] keyManagerArray2 = null;
                        StreamUtil.closeStream((Closeable)inputStream);
                        return keyManagerArray2;
                    }
                    throw e2;
                }
            }
            StreamUtil.closeStream((Closeable)inputStream);
            return factory.getKeyManagers();
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        return null;
    }

    @NotNull
    public String getCacertsPath() {
        return DEFAULT_PATH;
    }

    @NotNull
    public String getPassword() {
        return DEFAULT_PASSWORD;
    }

    @NotNull
    public ConfirmingTrustManager getTrustManager() {
        return (ConfirmingTrustManager)this.myTrustManager.getValue();
    }

    @NotNull
    public ConfirmingTrustManager.MutableTrustManager getCustomTrustManager() {
        return this.getTrustManager().getCustomManager();
    }

    public static boolean showAcceptDialog(@NotNull Callable<? extends DialogWrapper> dialogFactory) {
        Application app = ApplicationManager.getApplication();
        CountDownLatch proceeded = new CountDownLatch(1);
        AtomicBoolean accepted = new AtomicBoolean();
        AtomicReference dialogRef = new AtomicReference();
        Runnable showDialog = () -> {
            if (proceeded.getCount() == 0L) {
                return;
            }
            try {
                DialogWrapper dialog = (DialogWrapper)dialogFactory.call();
                dialogRef.set(dialog);
                accepted.set(dialog.showAndGet());
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
            finally {
                proceeded.countDown();
            }
        };
        if (app.isDispatchThread()) {
            showDialog.run();
        } else {
            app.invokeLater(showDialog, ModalityState.any());
        }
        try {
            boolean inTime = proceeded.await(5000L, TimeUnit.MILLISECONDS);
            if (!inTime) {
                DialogWrapper dialog = (DialogWrapper)dialogRef.get();
                if (dialog == null || !dialog.isShowing()) {
                    LOG.debug("After 5000 ms dialog was not shown. Rejecting certificate. Current thread: " + Thread.currentThread().getName());
                    proceeded.countDown();
                    return false;
                }
                proceeded.await();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            proceeded.countDown();
        }
        return accepted.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, E extends Throwable> T runWithUntrustedCertificateStrategy(@NotNull ThrowableComputable<T, E> computable, @NotNull UntrustedCertificateStrategy strategy) throws E {
        ConfirmingTrustManager trustManager = this.getTrustManager();
        trustManager.myUntrustedCertificateStrategy.set(strategy);
        try {
            Object object = computable.compute();
            return (T)object;
        }
        finally {
            trustManager.myUntrustedCertificateStrategy.remove();
        }
    }

    @Override
    @NotNull
    public Config getState() {
        return this.myConfig;
    }

    @Override
    public void loadState(@NotNull Config state) {
        XmlSerializerUtil.copyBean((Object)state, (Object)this.myConfig);
    }

    public static class Config {
        public boolean ACCEPT_AUTOMATICALLY = false;
    }
}

