/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.ide.plugins.PluginUtil;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.IntObjectMap;
import com.intellij.util.indexing.IndexId;
import com.intellij.util.io.SimpleStringPersistentEnumerator;
import gnu.trove.THashMap;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ID<K, V>
extends IndexId<K, V> {
    private static final Logger LOG = Logger.getInstance(ID.class);
    private static final IntObjectMap<ID<?, ?>> ourRegistry = ContainerUtil.createConcurrentIntObjectMap();
    private static final SimpleStringPersistentEnumerator ourNameToIdRegistry = new SimpleStringPersistentEnumerator(ID.getEnumFile());
    private static final Map<ID<?, ?>, PluginId> ourIdToPluginId = Collections.synchronizedMap(new THashMap());
    private static final Map<ID<?, ?>, Throwable> ourIdToRegistrationStackTrace = Collections.synchronizedMap(new THashMap());
    static final int MAX_NUMBER_OF_INDICES = Short.MAX_VALUE;
    private final short myUniqueId;

    @NotNull
    private static Path getEnumFile() {
        return PathManager.getIndexRoot().toPath().resolve("indices.enum");
    }

    @ApiStatus.Internal
    protected ID(@NotNull String name, @Nullable PluginId pluginId) {
        super(name);
        this.myUniqueId = ID.stringToId(name);
        ID old = (ID)((Object)ourRegistry.put((int)this.myUniqueId, (Object)this));
        assert (old == null) : "ID with name '" + name + "' is already registered";
        PluginId oldPluginId = ourIdToPluginId.put(this, pluginId);
        assert (oldPluginId == null) : "ID with name '" + name + "' is already registered in " + oldPluginId + " but current caller is " + pluginId;
        ourIdToRegistrationStackTrace.put(this, new Throwable());
    }

    private static short stringToId(@NotNull String name) {
        return ourNameToIdRegistry.enumerate(name);
    }

    static void reinitializeDiskStorage() {
        ourNameToIdRegistry.forceDiskSync();
    }

    @NotNull
    public static synchronized <K, V> ID<K, V> create(@NonNls @NotNull String name) {
        PluginId pluginId = ID.getCallerPluginId();
        ID<K, V> found = ID.findByName(name, true, pluginId);
        return found == null ? new ID<K, V>(name, pluginId) : found;
    }

    @Nullable
    public static <K, V> ID<K, V> findByName(@NotNull String name) {
        return ID.findByName(name, false, null);
    }

    @ApiStatus.Internal
    @Nullable
    protected static <K, V> ID<K, V> findByName(@NotNull String name, boolean checkCallerPlugin, @Nullable PluginId requiredPluginId) {
        ID<?, ?> id = ID.findById(ID.stringToId(name));
        if (checkCallerPlugin && id != null) {
            String requiredPluginIdStr;
            PluginId actualPluginId = ourIdToPluginId.get(id);
            String actualPluginIdStr = actualPluginId == null ? null : actualPluginId.getIdString();
            String string = requiredPluginIdStr = requiredPluginId == null ? null : requiredPluginId.getIdString();
            if (!Objects.equals(actualPluginIdStr, requiredPluginIdStr)) {
                Throwable registrationStackTrace = ourIdToRegistrationStackTrace.get(id);
                String message = "ID with name '" + name + "' requested for plugin " + requiredPluginIdStr + " but registered for " + actualPluginIdStr + (registrationStackTrace == null ? " registration stack trace: " : "");
                if (registrationStackTrace != null) {
                    throw new AssertionError(message, registrationStackTrace);
                }
                throw new AssertionError((Object)message);
            }
        }
        return id;
    }

    @ApiStatus.Internal
    @NotNull
    public Throwable getRegistrationTrace() {
        return ourIdToRegistrationStackTrace.get((Object)this);
    }

    public final int hashCode() {
        return this.myUniqueId;
    }

    public final boolean equals(Object obj) {
        return this == obj;
    }

    public int getUniqueId() {
        return this.myUniqueId;
    }

    @ApiStatus.Internal
    @Nullable
    public PluginId getPluginId() {
        return ourIdToPluginId.get((Object)this);
    }

    public static ID<?, ?> findById(int id) {
        return (ID)((Object)ourRegistry.get(id));
    }

    @ApiStatus.Internal
    @Nullable
    protected static PluginId getCallerPluginId() {
        return PluginUtil.getInstance().getCallerPlugin(4);
    }

    @ApiStatus.Internal
    public static synchronized void unloadId(@NotNull ID<?, ?> id) {
        LOG.assertTrue(id.equals(ourRegistry.remove(id.getUniqueId())));
        ourIdToPluginId.remove(id);
        ourIdToRegistrationStackTrace.remove(id);
    }

    public static void dump() {
        Logger.getInstance(ID.class).info("ID registry: " + ourRegistry.toString());
    }
}

