/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.concurrency.AsyncFuture;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.util.AbstractQuery;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class UniqueResultsQuery<T, M>
extends AbstractQuery<T> {
    @NotNull
    private final Query<? extends T> myOriginal;
    @NotNull
    private final TObjectHashingStrategy<? super M> myHashingStrategy;
    @NotNull
    private final Function<? super T, ? extends M> myMapper;

    public UniqueResultsQuery(@NotNull Query<? extends T> original) {
        this(original, ContainerUtil.canonicalStrategy(), Functions.identity());
    }

    public UniqueResultsQuery(@NotNull Query<? extends T> original, @NotNull TObjectHashingStrategy<? super M> hashingStrategy) {
        this(original, hashingStrategy, Functions.identity());
    }

    public UniqueResultsQuery(@NotNull Query<? extends T> original, @NotNull TObjectHashingStrategy<? super M> hashingStrategy, @NotNull Function<? super T, ? extends M> mapper) {
        this.myOriginal = original;
        this.myHashingStrategy = hashingStrategy;
        this.myMapper = mapper;
    }

    @Override
    protected boolean processResults(@NotNull Processor<? super T> consumer) {
        return UniqueResultsQuery.delegateProcessResults(this.myOriginal, new MyProcessor(Collections.synchronizedSet(new THashSet(this.myHashingStrategy)), consumer));
    }

    @Override
    @NotNull
    public AsyncFuture<Boolean> forEachAsync(@NotNull Processor<? super T> consumer) {
        return this.myOriginal.forEachAsync(new MyProcessor(Collections.synchronizedSet(new THashSet(this.myHashingStrategy)), consumer));
    }

    public String toString() {
        return "UniqueQuery: " + this.myOriginal;
    }

    private class MyProcessor
    implements Processor<T> {
        private final Set<? super M> myProcessedElements;
        private final Processor<? super T> myConsumer;

        MyProcessor(@NotNull Set<? super M> processedElements, Processor<? super T> consumer) {
            this.myProcessedElements = processedElements;
            this.myConsumer = consumer;
        }

        public boolean process(T t) {
            ProgressManager.checkCanceled();
            Object m = UniqueResultsQuery.this.myMapper.fun(t);
            if (this.myProcessedElements.contains(m)) {
                return true;
            }
            boolean result = this.myConsumer.process(t);
            this.myProcessedElements.add(m);
            return result;
        }
    }
}

