/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.concurrency.AsyncFuture;
import com.intellij.util.Processor;
import com.intellij.util.Queries;
import java.util.Collection;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Query<Result>
extends Iterable<Result> {
    @NotNull
    public Collection<Result> findAll();

    @Nullable
    public Result findFirst();

    public boolean forEach(@NotNull Processor<? super Result> var1);

    @NotNull
    public AsyncFuture<Boolean> forEachAsync(@NotNull Processor<? super Result> var1);

    public Result @NotNull [] toArray(Result @NotNull [] var1);

    @Contract(pure=true)
    default public boolean allMatch(@NotNull Predicate<? super Result> predicate) {
        return this.forEach(predicate::test);
    }

    @Contract(pure=true)
    default public boolean anyMatch(@NotNull Predicate<? super Result> predicate) {
        return !this.forEach(t -> !predicate.test((Object)t));
    }

    @ApiStatus.Experimental
    @NotNull
    default public <R> Query<R> mapping(@NotNull Function<? super Result, ? extends R> mapper) {
        return Queries.getInstance().mapping(this, mapper);
    }

    @ApiStatus.Experimental
    @NotNull
    default public Query<Result> filtering(@NotNull Predicate<? super Result> predicate) {
        return Queries.getInstance().filtering(this, predicate);
    }

    @ApiStatus.Experimental
    @NotNull
    default public <R> Query<R> flatMapping(@NotNull Function<? super Result, ? extends Query<? extends R>> mapper) {
        return Queries.getInstance().flatMapping(this, mapper);
    }

    @NotNull
    @Contract(pure=true)
    default public Query<Result> allowParallelProcessing() {
        return this;
    }
}

