/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.JBIterable;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class PathsList {
    private final List<String> myPath = new ArrayList<String>();
    private final List<String> myPathTail = new ArrayList<String>();
    private final Set<String> myPathSet = new HashSet<String>();
    private static final Function<String, VirtualFile> PATH_TO_LOCAL_VFILE = path2 -> StandardFileSystems.local().findFileByPath(path2.replace(File.separatorChar, '/'));
    private static final Function<VirtualFile, String> LOCAL_PATH = file -> PathUtil.getLocalPath(file);
    private static final Function<String, VirtualFile> PATH_TO_DIR = s -> {
        VirtualFile file = (VirtualFile)PATH_TO_LOCAL_VFILE.fun(s);
        if (file == null) {
            return null;
        }
        if (!file.isDirectory() && FileTypeRegistry.getInstance().getFileTypeByFileName(file.getNameSequence()) == ArchiveFileType.INSTANCE) {
            return StandardFileSystems.jar().findFileByPath(file.getPath() + "!/");
        }
        return file;
    };

    public boolean isEmpty() {
        return this.myPathSet.isEmpty();
    }

    public void add(String path2) {
        this.addAllLast(this.chooseFirstTimeItems(path2), this.myPath);
    }

    public void remove(@NotNull String path2) {
        this.myPath.remove(path2);
        this.myPathTail.remove(path2);
        this.myPathSet.remove(path2);
    }

    public void clear() {
        this.myPath.clear();
        this.myPathTail.clear();
        this.myPathSet.clear();
    }

    public void add(VirtualFile file) {
        this.add((String)LOCAL_PATH.fun((Object)file));
    }

    public void addFirst(String path2) {
        int index = 0;
        for (String element : this.chooseFirstTimeItems(path2)) {
            this.myPath.add(index, element);
            this.myPathSet.add(element);
            ++index;
        }
    }

    public void addTail(String path2) {
        this.addAllLast(this.chooseFirstTimeItems(path2), this.myPathTail);
    }

    private Iterable<String> chooseFirstTimeItems(String path2) {
        if (path2 == null) {
            return Collections.emptyList();
        }
        return JBIterable.from((Iterable)StringUtil.tokenize((String)path2, (String)File.pathSeparator)).filter(element -> !(element = element.trim()).isEmpty() && !this.myPathSet.contains(element));
    }

    private void addAllLast(Iterable<String> elements, List<? super String> toArray) {
        for (String element : elements) {
            toArray.add(element);
            this.myPathSet.add(element);
        }
    }

    @NotNull
    public String getPathsString() {
        return StringUtil.join(this.getPathList(), (String)File.pathSeparator);
    }

    @NotNull
    public List<String> getPathList() {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(this.myPath);
        result.addAll(this.myPathTail);
        return result;
    }

    public List<VirtualFile> getVirtualFiles() {
        return JBIterable.from(this.getPathList()).filterMap(PATH_TO_LOCAL_VFILE).toList();
    }

    public List<VirtualFile> getRootDirs() {
        return JBIterable.from(this.getPathList()).filterMap(PATH_TO_DIR).toList();
    }

    public void addAll(List<String> allClasspath) {
        for (String path2 : allClasspath) {
            this.add(path2);
        }
    }

    public void addAllFiles(File[] files) {
        this.addAllFiles(Arrays.asList(files));
    }

    public void addAllFiles(List<? extends File> files) {
        for (File file : files) {
            this.add(file);
        }
    }

    public void add(File file) {
        this.add(FileUtil.toCanonicalPath((String)file.getAbsolutePath()).replace('/', File.separatorChar));
    }

    public void addFirst(File file) {
        this.addFirst(FileUtil.toCanonicalPath((String)file.getAbsolutePath()).replace('/', File.separatorChar));
    }

    public void addVirtualFiles(Collection<? extends VirtualFile> files) {
        for (VirtualFile virtualFile2 : files) {
            this.add(virtualFile2);
        }
    }

    public void addVirtualFiles(VirtualFile[] files) {
        this.addVirtualFiles(Arrays.asList(files));
    }
}

