/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewSettings;
import com.intellij.usages.impl.UsageViewImpl;
import com.intellij.usages.rules.UsageFilteringRuleProvider;
import java.util.function.Supplier;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class RuleAction
extends ToggleAction
implements DumbAware {
    protected RuleAction(@NotNull String text, @NotNull Icon icon) {
        this(() -> text, icon);
    }

    protected RuleAction(@NotNull Supplier<String> text, @NotNull Icon icon) {
        super(text, icon);
    }

    protected abstract boolean getOptionValue(@NotNull AnActionEvent var1);

    protected abstract void setOptionValue(@NotNull AnActionEvent var1, boolean var2);

    @Override
    public boolean isSelected(@NotNull AnActionEvent e) {
        return this.getOptionValue(e);
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        super.update(e);
        e.getPresentation().setEnabled(this.getUsageViewImpl(e) != null);
    }

    @Override
    public void setSelected(@NotNull AnActionEvent e, boolean state) {
        this.setOptionValue(e, state);
        Project project = e.getProject();
        if (project != null) {
            ((Runnable)project.getMessageBus().syncPublisher(UsageFilteringRuleProvider.RULES_CHANGED)).run();
        }
    }

    @NotNull
    protected UsageViewSettings getUsageViewSettings(@NotNull AnActionEvent e) {
        UsageView plainView = e.getData(UsageView.USAGE_VIEW_KEY);
        if (plainView instanceof UsageViewImpl) {
            return ((UsageViewImpl)plainView).getUsageViewSettings();
        }
        return UsageViewSettings.getInstance();
    }

    @Nullable
    protected UsageViewImpl getUsageViewImpl(@NotNull AnActionEvent e) {
        UsageView plainView = e.getData(UsageView.USAGE_VIEW_KEY);
        if (plainView instanceof UsageViewImpl) {
            return (UsageViewImpl)plainView;
        }
        return null;
    }
}

