/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.usages.TextChunk;
import com.intellij.usages.Usage;
import com.intellij.usages.UsagePresentation;
import com.intellij.usages.impl.UsageAdapter;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class UnknownUsagesInUnloadedModules
extends UsageAdapter
implements Usage {
    private final String myExplanationText;

    public UnknownUsagesInUnloadedModules(Collection<UnloadedModuleDescription> unloadedModules) {
        String modulesText = unloadedModules.size() > 1 ? unloadedModules.size() + " unloaded modules" : "unloaded module '" + ((UnloadedModuleDescription)Objects.requireNonNull(ContainerUtil.getFirstItem(unloadedModules))).getName() + "'";
        this.myExplanationText = "There may be usages in " + modulesText + ". Load all modules and repeat refactoring to ensure that all the usages will be updated.";
    }

    @Override
    @NotNull
    public UsagePresentation getPresentation() {
        return new UsagePresentation(){

            @Override
            public TextChunk @NotNull [] getText() {
                return new TextChunk[]{new TextChunk(SimpleTextAttributes.REGULAR_ATTRIBUTES.toTextAttributes(), UnknownUsagesInUnloadedModules.this.myExplanationText)};
            }

            @Override
            @NotNull
            public String getPlainText() {
                return UnknownUsagesInUnloadedModules.this.myExplanationText;
            }

            @Override
            public Icon getIcon() {
                return AllIcons.General.Warning;
            }

            @Override
            public String getTooltipText() {
                return null;
            }
        };
    }

    @Override
    public boolean isValid() {
        return true;
    }
}

