/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl;

import com.intellij.diagnostic.PerformanceWatcher;
import com.intellij.find.FindManager;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.progress.util.ProgressWrapper;
import com.intellij.openapi.progress.util.TooManyUsagesStatus;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usageView.UsageViewContentManager;
import com.intellij.usages.FindUsagesProcessPresentation;
import com.intellij.usages.PsiElementUsageTarget;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageSearcher;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.usages.impl.UsageViewEx;
import com.intellij.usages.impl.UsageViewImpl;
import com.intellij.usages.impl.UsageViewManagerImpl;
import com.intellij.util.Alarm;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.RangeBlinker;
import com.intellij.xml.util.XmlStringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class SearchForUsagesRunnable
implements Runnable {
    @NonNls
    private static final String FIND_OPTIONS_HREF_TARGET = "FindOptions";
    @NonNls
    private static final String SEARCH_IN_PROJECT_HREF_TARGET = "SearchInProject";
    @NonNls
    private static final String LARGE_FILES_HREF_TARGET = "LargeFiles";
    @NonNls
    private static final String SHOW_PROJECT_FILE_OCCURRENCES_HREF_TARGET = "SHOW_PROJECT_FILE_OCCURRENCES";
    private final AtomicInteger myUsageCountWithoutDefinition = new AtomicInteger(0);
    private final AtomicReference<Usage> myFirstUsage = new AtomicReference();
    @NotNull
    private final Project myProject;
    private final AtomicReference<UsageViewEx> myUsageViewRef;
    private final UsageViewPresentation myPresentation;
    private final UsageTarget[] mySearchFor;
    private final Factory<UsageSearcher> mySearcherFactory;
    private final FindUsagesProcessPresentation myProcessPresentation;
    @NotNull
    private final SearchScope mySearchScopeToWarnOfFallingOutOf;
    private final UsageViewManager.UsageViewStateListener myListener;
    private final UsageViewManagerImpl myUsageViewManager;
    private final AtomicInteger myOutOfScopeUsages = new AtomicInteger();

    SearchForUsagesRunnable(@NotNull UsageViewManagerImpl usageViewManager, @NotNull Project project, @NotNull AtomicReference<UsageViewEx> usageViewRef, @NotNull UsageViewPresentation presentation, UsageTarget @NotNull [] searchFor, @NotNull Factory<UsageSearcher> searcherFactory, @NotNull FindUsagesProcessPresentation processPresentation, @NotNull SearchScope searchScopeToWarnOfFallingOutOf, @Nullable UsageViewManager.UsageViewStateListener listener2) {
        this.myProject = project;
        this.myUsageViewRef = usageViewRef;
        this.myPresentation = presentation;
        this.mySearchFor = searchFor;
        this.mySearcherFactory = searcherFactory;
        this.myProcessPresentation = processPresentation;
        this.mySearchScopeToWarnOfFallingOutOf = searchScopeToWarnOfFallingOutOf;
        this.myListener = listener2;
        this.myUsageViewManager = usageViewManager;
    }

    @NotNull
    private static String createOptionsHtml(@NonNls UsageTarget @NotNull [] searchFor) {
        KeyboardShortcut shortcut = UsageViewImpl.getShowUsagesWithSettingsShortcut(searchFor);
        String shortcutText = "";
        if (shortcut != null) {
            shortcutText = "&nbsp;(" + KeymapUtil.getShortcutText(shortcut) + ")";
        }
        return "<a href='FindOptions'>Find Options...</a>" + shortcutText;
    }

    @NotNull
    private static String createSearchInProjectHtml() {
        return "<a href='SearchInProject'>Search in Project</a>";
    }

    private void notifyByFindBalloon(@Nullable HyperlinkListener listener2, @NotNull MessageType messageType, @NotNull List<String> lines) {
        Runnable searchIncludingProjectFileUsages;
        UsageViewContentManager.getInstance(this.myProject);
        Collection<VirtualFile> largeFiles = this.myProcessPresentation.getLargeFiles();
        ArrayList<String> resultLines = new ArrayList<String>(lines);
        HyperlinkListener resultListener = listener2;
        if (!largeFiles.isEmpty()) {
            String shortMessage = "(<a href='LargeFiles'>" + UsageViewBundle.message("large.files.were.ignored", largeFiles.size()) + "</a>)";
            resultLines.add(shortMessage);
            resultListener = SearchForUsagesRunnable.addHrefHandling(resultListener, LARGE_FILES_HREF_TARGET, () -> {
                String detailedMessage = SearchForUsagesRunnable.detailedLargeFilesMessage(largeFiles);
                ArrayList<String> strings = new ArrayList<String>(lines);
                strings.add(detailedMessage);
                ToolWindowManager.getInstance(this.myProject).notifyByBalloon("Find", messageType, SearchForUsagesRunnable.wrapInHtml(strings), AllIcons.Actions.Find, listener2);
            });
        }
        if ((searchIncludingProjectFileUsages = this.myProcessPresentation.searchIncludingProjectFileUsages()) != null) {
            resultLines.add("Occurrences in project configuration files are skipped. <a href='SHOW_PROJECT_FILE_OCCURRENCES'>Include them</a>");
            resultListener = SearchForUsagesRunnable.addHrefHandling(resultListener, SHOW_PROJECT_FILE_OCCURRENCES_HREF_TARGET, searchIncludingProjectFileUsages);
        }
        Collection<UnloadedModuleDescription> unloaded = this.getUnloadedModulesBelongingToScope();
        MessageType actualType = messageType;
        if (!unloaded.isEmpty()) {
            if (actualType == MessageType.INFO) {
                actualType = MessageType.WARNING;
            }
            resultLines.add(SearchForUsagesRunnable.mayHaveUsagesInUnloadedModulesMessage(unloaded));
        }
        ToolWindowManager.getInstance(this.myProject).notifyByBalloon("Find", actualType, SearchForUsagesRunnable.wrapInHtml(resultLines), AllIcons.Actions.Find, resultListener);
    }

    @NotNull
    private Collection<UnloadedModuleDescription> getUnloadedModulesBelongingToScope() {
        return (Collection)ReadAction.compute(() -> {
            if (!(this.mySearchScopeToWarnOfFallingOutOf instanceof GlobalSearchScope)) {
                return Collections.emptySet();
            }
            Collection<UnloadedModuleDescription> unloadedInSearchScope = ((GlobalSearchScope)this.mySearchScopeToWarnOfFallingOutOf).getUnloadedModulesBelongingToScope();
            Set<UnloadedModuleDescription> unloadedInUseScope = this.getUnloadedModulesBelongingToUseScopes();
            if (unloadedInUseScope != null) {
                return ContainerUtil.intersection(unloadedInSearchScope, unloadedInUseScope);
            }
            return unloadedInSearchScope;
        });
    }

    private Set<UnloadedModuleDescription> getUnloadedModulesBelongingToUseScopes() {
        LinkedHashSet<UnloadedModuleDescription> resolveScope = new LinkedHashSet<UnloadedModuleDescription>();
        for (UsageTarget target : this.mySearchFor) {
            if (!(target instanceof PsiElementUsageTarget)) {
                return null;
            }
            PsiElement element = ((PsiElementUsageTarget)target).getElement();
            if (element == null) {
                return null;
            }
            SearchScope useScope = element.getUseScope();
            if (!(useScope instanceof GlobalSearchScope)) continue;
            resolveScope.addAll(((GlobalSearchScope)useScope).getUnloadedModulesBelongingToScope());
        }
        return resolveScope;
    }

    @NotNull
    private static HyperlinkListener addHrefHandling(final @Nullable HyperlinkListener listener2, final @NotNull String hrefTarget, final @NotNull Runnable handler) {
        return new HyperlinkAdapter(){

            protected void hyperlinkActivated(HyperlinkEvent e) {
                if (e.getDescription().equals(hrefTarget)) {
                    handler.run();
                } else if (listener2 != null) {
                    listener2.hyperlinkUpdate(e);
                }
            }
        };
    }

    @NotNull
    private static String wrapInHtml(@NotNull List<String> strings) {
        return XmlStringUtil.wrapInHtml((CharSequence)StringUtil.join(strings, (String)"<br>"));
    }

    @NotNull
    private static String detailedLargeFilesMessage(@NotNull Collection<? extends VirtualFile> largeFiles) {
        String message;
        if (largeFiles.size() == 1) {
            VirtualFile vFile2 = largeFiles.iterator().next();
            message = "File " + SearchForUsagesRunnable.presentableFileInfo(vFile2) + " is ";
        } else {
            message = "Files<br> " + StringUtil.join((Collection)ContainerUtil.getFirstItems(new ArrayList<VirtualFile>(largeFiles), (int)10), vFile -> SearchForUsagesRunnable.presentableFileInfo(vFile), (String)"<br> ") + "<br> are ";
        }
        message = message + "too large and cannot be scanned";
        return message;
    }

    @NotNull
    private static String presentableFileInfo(@NotNull VirtualFile vFile) {
        return SearchForUsagesRunnable.getPresentablePath(vFile) + "&nbsp;(" + UsageViewManagerImpl.presentableSize(UsageViewManagerImpl.getFileLength(vFile)) + ")";
    }

    @NotNull
    private static String getPresentablePath(@NotNull VirtualFile virtualFile2) {
        return "'" + (String)ReadAction.compute(virtualFile2::getPresentableUrl) + "'";
    }

    @NotNull
    private HyperlinkListener createGotToOptionsListener(final UsageTarget @NotNull [] targets) {
        return new HyperlinkAdapter(){

            protected void hyperlinkActivated(HyperlinkEvent e) {
                if (e.getDescription().equals(SearchForUsagesRunnable.FIND_OPTIONS_HREF_TARGET)) {
                    FindManager.getInstance(SearchForUsagesRunnable.this.myProject).showSettingsAndFindUsages(targets);
                }
            }
        };
    }

    @NotNull
    private HyperlinkListener createSearchInProjectListener() {
        return new HyperlinkAdapter(){

            protected void hyperlinkActivated(HyperlinkEvent e) {
                PsiElement psiElement;
                if (e.getDescription().equals(SearchForUsagesRunnable.SEARCH_IN_PROJECT_HREF_TARGET) && (psiElement = SearchForUsagesRunnable.getPsiElement(SearchForUsagesRunnable.this.mySearchFor)) != null) {
                    FindManager.getInstance(SearchForUsagesRunnable.this.myProject).findUsagesInScope(psiElement, GlobalSearchScope.projectScope(SearchForUsagesRunnable.this.myProject));
                }
            }
        };
    }

    private static PsiElement getPsiElement(UsageTarget @NotNull [] searchFor) {
        UsageTarget target = searchFor[0];
        if (!(target instanceof PsiElementUsageTarget)) {
            return null;
        }
        return (PsiElement)ReadAction.compute(((PsiElementUsageTarget)target)::getElement);
    }

    private static void flashUsageScriptaculously(@NotNull Usage usage) {
        if (!(usage instanceof UsageInfo2UsageAdapter)) {
            return;
        }
        UsageInfo2UsageAdapter usageInfo = (UsageInfo2UsageAdapter)usage;
        Editor editor = usageInfo.openTextEditor(true);
        if (editor == null) {
            return;
        }
        TextAttributes attributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(CodeInsightColors.BLINKING_HIGHLIGHTS_ATTRIBUTES);
        RangeBlinker rangeBlinker = new RangeBlinker(editor, attributes, 6);
        ArrayList segments = new ArrayList();
        Processor processor = Processors.cancelableCollectProcessor(segments);
        usageInfo.processRangeMarkers(processor);
        rangeBlinker.resetMarkers(segments);
        rangeBlinker.startBlinking();
    }

    private UsageViewEx getUsageView(@NotNull ProgressIndicator indicator, long startSearchStamp) {
        UsageView usageView = this.myUsageViewRef.get();
        if (usageView != null) {
            return usageView;
        }
        int usageCount = this.myUsageCountWithoutDefinition.get();
        if (usageCount == 0 || usageCount == 1 && !this.myProcessPresentation.isShowPanelIfOnlyOneUsage() && System.currentTimeMillis() < startSearchStamp + 500L) {
            return null;
        }
        usageView = this.myUsageViewManager.createUsageView(this.mySearchFor, Usage.EMPTY_ARRAY, this.myPresentation, (Factory)this.mySearcherFactory);
        if (this.myUsageViewRef.compareAndSet(null, (UsageViewEx)usageView)) {
            usageView.associateProgress(indicator);
            if (this.myProcessPresentation.isShowFindOptionsPrompt()) {
                this.openView((UsageViewEx)usageView);
            } else if (this.myListener != null) {
                SwingUtilities.invokeLater(() -> {
                    UsageViewEx uv;
                    if (!this.myProject.isDisposed() && (uv = this.myUsageViewRef.get()) != null) {
                        this.myListener.usageViewCreated(uv);
                    }
                });
            }
            Usage firstUsage = this.myFirstUsage.get();
            if (firstUsage != null) {
                UsageView finalUsageView = usageView;
                ApplicationManager.getApplication().runReadAction(() -> SearchForUsagesRunnable.lambda$getUsageView$4((UsageViewEx)finalUsageView, firstUsage));
            }
        } else {
            UsageView finalUsageView = usageView;
            Disposer.register((Disposable)this.myProject, (Disposable)usageView);
            ((AppUIExecutor)AppUIExecutor.onUiThread(ModalityState.any()).expireWith((Disposable)this.myProject)).execute(() -> SearchForUsagesRunnable.lambda$getUsageView$5((UsageViewEx)finalUsageView));
        }
        return this.myUsageViewRef.get();
    }

    private void openView(@NotNull UsageViewEx usageView) {
        SwingUtilities.invokeLater(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            this.myUsageViewManager.showUsageView(usageView, this.myPresentation);
            if (this.myListener != null) {
                this.myListener.usageViewCreated(usageView);
            }
            this.myUsageViewManager.showToolWindow(false);
        });
    }

    @Override
    public void run() {
        PerformanceWatcher.Snapshot snapshot = PerformanceWatcher.takeSnapshot();
        AtomicBoolean findUsagesStartedShown = new AtomicBoolean();
        this.searchUsages(findUsagesStartedShown);
        this.endSearchForUsages(findUsagesStartedShown);
        snapshot.logResponsivenessSinceCreation("Find Usages");
    }

    private void searchUsages(@NotNull AtomicBoolean findStartedBalloonShown) {
        ProgressIndicator current = ProgressManager.getInstance().getProgressIndicator();
        if (current == null) {
            throw new IllegalStateException("must run find usages under progress");
        }
        ProgressIndicator indicator = ProgressWrapper.unwrapAll((ProgressIndicator)current);
        if (!ApplicationManager.getApplication().isDispatchThread()) {
            CoreProgressManager.assertUnderProgress((ProgressIndicator)indicator);
        }
        TooManyUsagesStatus.createFor((ProgressIndicator)indicator);
        Alarm findUsagesStartedBalloon = new Alarm();
        findUsagesStartedBalloon.addRequest(() -> {
            this.notifyByFindBalloon(null, MessageType.WARNING, Collections.singletonList(StringUtil.escapeXmlEntities((String)UsageViewManagerImpl.getProgressTitle(this.myPresentation))));
            findStartedBalloonShown.set(true);
        }, 300, ModalityState.NON_MODAL);
        UsageSearcher usageSearcher = (UsageSearcher)this.mySearcherFactory.create();
        long startSearchStamp = System.currentTimeMillis();
        usageSearcher.generate((Processor<? super Usage>)((Processor)usage -> {
            boolean incrementCounter;
            ProgressIndicator currentIndicator = ProgressManager.getInstance().getProgressIndicator();
            if (currentIndicator == null) {
                throw new IllegalStateException("must run find usages under progress");
            }
            ProgressIndicator originalIndicator = ProgressWrapper.unwrapAll((ProgressIndicator)current);
            ProgressManager.checkCanceled();
            if (!UsageViewManagerImpl.isInScope(usage, this.mySearchScopeToWarnOfFallingOutOf)) {
                this.myOutOfScopeUsages.incrementAndGet();
                return true;
            }
            boolean bl = incrementCounter = !UsageViewManager.isSelfUsage(usage, this.mySearchFor);
            if (incrementCounter) {
                int usageCount = this.myUsageCountWithoutDefinition.incrementAndGet();
                if (usageCount == 1 && !this.myProcessPresentation.isShowPanelIfOnlyOneUsage()) {
                    this.myFirstUsage.compareAndSet((Usage)null, (Usage)usage);
                }
                UsageViewEx usageView = this.getUsageView(originalIndicator, startSearchStamp);
                TooManyUsagesStatus tooManyUsagesStatus = TooManyUsagesStatus.getFrom((ProgressIndicator)originalIndicator);
                if (usageCount > 1000 && tooManyUsagesStatus.switchTooManyUsagesStatus()) {
                    UsageViewManagerImpl.showTooManyUsagesWarningLater(this.myProject, tooManyUsagesStatus, originalIndicator, usageView);
                }
                tooManyUsagesStatus.pauseProcessingIfTooManyUsages();
                if (usageView != null) {
                    ApplicationManager.getApplication().runReadAction(() -> usageView.appendUsage((Usage)usage));
                }
            }
            return true;
        }));
        if (this.getUsageView(indicator, startSearchStamp) != null) {
            ApplicationManager.getApplication().invokeLater(() -> this.myUsageViewManager.showToolWindow(true), this.myProject.getDisposed());
        }
        Disposer.dispose((Disposable)findUsagesStartedBalloon);
        ApplicationManager.getApplication().invokeLater(() -> {
            Balloon balloon;
            if (findStartedBalloonShown.get() && (balloon = ToolWindowManager.getInstance(this.myProject).getToolWindowBalloon("Find")) != null) {
                balloon.hide();
            }
        }, this.myProject.getDisposed());
    }

    private void endSearchForUsages(@NotNull AtomicBoolean findStartedBalloonShown) {
        UsageViewEx usageView;
        assert (!ApplicationManager.getApplication().isDispatchThread()) : Thread.currentThread();
        int usageCount = this.myUsageCountWithoutDefinition.get();
        if (usageCount == 0) {
            if (this.myProcessPresentation.isShowNotFoundMessage()) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (this.myProcessPresentation.isCanceled()) {
                        this.notifyByFindBalloon(null, MessageType.WARNING, Collections.singletonList("Usage search was canceled"));
                        findStartedBalloonShown.set(false);
                        return;
                    }
                    ArrayList<String> lines = new ArrayList<String>();
                    lines.add(StringUtil.escapeXmlEntities((String)this.myPresentation.getSearchString()));
                    lines.add(UsageViewBundle.message("search.result.nothing.in.0", StringUtil.escapeXmlEntities((String)this.myPresentation.getScopeText())));
                    if (this.myOutOfScopeUsages.get() != 0) {
                        lines.add(UsageViewManagerImpl.outOfScopeMessage(this.myOutOfScopeUsages.get(), this.mySearchScopeToWarnOfFallingOutOf));
                    }
                    if (this.myProcessPresentation.isShowFindOptionsPrompt()) {
                        lines.add(SearchForUsagesRunnable.createOptionsHtml(this.mySearchFor));
                    }
                    MessageType type = this.myOutOfScopeUsages.get() == 0 ? MessageType.INFO : MessageType.WARNING;
                    this.notifyByFindBalloon(this.createGotToOptionsListener(this.mySearchFor), type, lines);
                    findStartedBalloonShown.set(false);
                }, ModalityState.NON_MODAL, this.myProject.getDisposed());
            }
        } else if (usageCount == 1 && !this.myProcessPresentation.isShowPanelIfOnlyOneUsage()) {
            ApplicationManager.getApplication().invokeLater(() -> {
                Usage usage = this.myFirstUsage.get();
                if (usage.canNavigate()) {
                    usage.navigate(true);
                    SearchForUsagesRunnable.flashUsageScriptaculously(usage);
                }
                ArrayList<String> lines = new ArrayList<String>();
                lines.add("Only one usage found.");
                if (this.myOutOfScopeUsages.get() != 0) {
                    lines.add(UsageViewManagerImpl.outOfScopeMessage(this.myOutOfScopeUsages.get(), this.mySearchScopeToWarnOfFallingOutOf));
                }
                lines.add(SearchForUsagesRunnable.createOptionsHtml(this.mySearchFor));
                MessageType type = this.myOutOfScopeUsages.get() == 0 ? MessageType.INFO : MessageType.WARNING;
                this.notifyByFindBalloon(this.createGotToOptionsListener(this.mySearchFor), type, lines);
            }, ModalityState.NON_MODAL, this.myProject.getDisposed());
        } else {
            HyperlinkListener hyperlinkListener;
            List<Object> lines;
            usageView = this.myUsageViewRef.get();
            usageView.searchFinished();
            if (this.myOutOfScopeUsages.get() == 0 || SearchForUsagesRunnable.getPsiElement(this.mySearchFor) == null) {
                lines = Collections.emptyList();
                hyperlinkListener = null;
            } else {
                lines = Arrays.asList(UsageViewManagerImpl.outOfScopeMessage(this.myOutOfScopeUsages.get(), this.mySearchScopeToWarnOfFallingOutOf), SearchForUsagesRunnable.createSearchInProjectHtml());
                hyperlinkListener = this.createSearchInProjectListener();
            }
            if (!this.myProcessPresentation.getLargeFiles().isEmpty() || this.myOutOfScopeUsages.get() != 0 || this.myProcessPresentation.searchIncludingProjectFileUsages() != null || !this.getUnloadedModulesBelongingToScope().isEmpty()) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    MessageType type = this.myOutOfScopeUsages.get() == 0 ? MessageType.INFO : MessageType.WARNING;
                    this.notifyByFindBalloon(hyperlinkListener, type, lines);
                }, ModalityState.NON_MODAL, this.myProject.getDisposed());
            }
        }
        if ((usageView = this.myUsageViewRef.get()) != null) {
            usageView.waitForUpdateRequestsCompletion();
        }
        if (this.myListener != null) {
            this.myListener.findingUsagesFinished(usageView);
        }
    }

    @NotNull
    private static String mayHaveUsagesInUnloadedModulesMessage(@NotNull Collection<? extends UnloadedModuleDescription> unloadedModules) {
        String modulesText = unloadedModules.size() > 1 ? unloadedModules.size() + " unloaded modules" : "unloaded module '" + ((UnloadedModuleDescription)Objects.requireNonNull(ContainerUtil.getFirstItem(unloadedModules))).getName() + "'";
        return "Occurrences in " + modulesText + " may be skipped. Load all modules and repeat the search to get complete results.";
    }

    private static /* synthetic */ void lambda$getUsageView$5(UsageViewEx finalUsageView) {
        Disposer.dispose((Disposable)finalUsageView);
    }

    private static /* synthetic */ void lambda$getUsageView$4(UsageViewEx finalUsageView, Usage firstUsage) {
        finalUsageView.appendUsage(firstUsage);
    }
}

