/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.util.Key;
import com.intellij.ui.ComponentUtil;
import javax.swing.JButton;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public interface TouchbarDataKeys {
    public static final DataKey<ActionGroup> ACTIONS_KEY = DataKey.create("TouchBarActions");
    public static final Key<ActionDesc> ACTIONS_DESCRIPTOR_KEY = Key.create((String)"TouchBarActions.Descriptor");
    public static final Key<DlgButtonDesc> DIALOG_BUTTON_DESCRIPTOR_KEY = Key.create((String)"TouchBar.Dialog.SouthPanel.Button.Descriptor");

    @NotNull
    public static ActionDesc putActionDescriptor(@NotNull AnAction action) {
        ActionDesc result = action.getTemplatePresentation().getClientProperty(ACTIONS_DESCRIPTOR_KEY);
        if (result == null) {
            result = new ActionDesc();
            action.getTemplatePresentation().putClientProperty(ACTIONS_DESCRIPTOR_KEY, result);
        }
        return result;
    }

    @NotNull
    public static DlgButtonDesc putDialogButtonDescriptor(@NotNull JButton button, int orderIndex) {
        return TouchbarDataKeys.putDialogButtonDescriptor(button, orderIndex, false);
    }

    @NotNull
    public static DlgButtonDesc putDialogButtonDescriptor(@NotNull JButton button, int orderIndex, boolean isMainGroup) {
        DlgButtonDesc result = (DlgButtonDesc)ComponentUtil.getClientProperty((JComponent)button, DIALOG_BUTTON_DESCRIPTOR_KEY);
        if (result == null) {
            DlgButtonDesc value = result = new DlgButtonDesc(orderIndex);
            ComponentUtil.putClientProperty((JComponent)button, DIALOG_BUTTON_DESCRIPTOR_KEY, (Object)value);
        }
        result.setMainGroup(isMainGroup);
        return result;
    }

    public static class ActionDesc {
        private boolean myShowText = false;
        private boolean myShowImage = true;
        private boolean myReplaceEsc = false;
        private boolean myCombineWithDlgButtons = false;
        private boolean myIsMainGroup = false;
        private JComponent myContextComponent = null;

        public boolean isShowText() {
            return this.myShowText;
        }

        public boolean isShowImage() {
            return this.myShowImage;
        }

        public boolean isReplaceEsc() {
            return this.myReplaceEsc;
        }

        public boolean isCombineWithDlgButtons() {
            return this.myCombineWithDlgButtons;
        }

        public boolean isMainGroup() {
            return this.myIsMainGroup;
        }

        public JComponent getContextComponent() {
            return this.myContextComponent;
        }

        public ActionDesc setShowText(boolean showText) {
            this.myShowText = showText;
            return this;
        }

        public ActionDesc setShowImage(boolean showImage) {
            this.myShowImage = showImage;
            return this;
        }

        public ActionDesc setReplaceEsc(boolean replaceEsc) {
            this.myReplaceEsc = replaceEsc;
            return this;
        }

        public ActionDesc setCombineWithDlgButtons(boolean combineWithDlgButtons) {
            this.myCombineWithDlgButtons = combineWithDlgButtons;
            return this;
        }

        public ActionDesc setMainGroup(boolean mainGroup) {
            this.myIsMainGroup = mainGroup;
            return this;
        }

        public ActionDesc setContextComponent(JComponent contextComponent) {
            this.myContextComponent = contextComponent;
            return this;
        }
    }

    public static class DlgButtonDesc {
        private final int myOrderIndex;
        private boolean myIsMainGroup = false;
        private boolean myIsDefault = false;

        DlgButtonDesc(int orderIndex) {
            this.myOrderIndex = orderIndex;
        }

        public boolean isMainGroup() {
            return this.myIsMainGroup;
        }

        public boolean isDefault() {
            return this.myIsDefault;
        }

        public int getOrder() {
            return this.myOrderIndex;
        }

        public DlgButtonDesc setMainGroup(boolean mainGroup) {
            this.myIsMainGroup = mainGroup;
            return this;
        }

        public DlgButtonDesc setDefault(boolean aDefault) {
            this.myIsDefault = aDefault;
            return this;
        }
    }
}

