/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.jcef;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.jcef.DisposeHelper;
import com.intellij.ui.jcef.JBCefBrowser;
import com.intellij.ui.jcef.JBCefClient;
import com.intellij.ui.jcef.JBCefDisposable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.cef.CefClient;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefFrame;
import org.cef.browser.CefMessageRouter;
import org.cef.callback.CefQueryCallback;
import org.cef.handler.CefMessageRouterHandler;
import org.cef.handler.CefMessageRouterHandlerAdapter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JBCefJSQuery
implements JBCefDisposable {
    @NotNull
    private final JSQueryFunc myFunc;
    @NotNull
    private final CefClient myCefClient;
    @NotNull
    private final DisposeHelper myDisposeHelper = new DisposeHelper();
    @NotNull
    private final Map<Function<String, Response>, CefMessageRouterHandler> myHandlerMap = Collections.synchronizedMap(new HashMap());

    private JBCefJSQuery(@NotNull JBCefBrowser browser, @NotNull JSQueryFunc func) {
        this.myFunc = func;
        this.myCefClient = browser.getJBCefClient().getCefClient();
        Disposer.register((Disposable)browser, (Disposable)this);
    }

    public static JBCefJSQuery create(@NotNull JBCefBrowser browser) {
        JSQueryFunc slot;
        Function<Void, JBCefJSQuery> create = v -> new JBCefJSQuery(browser, new JSQueryFunc(browser.getJBCefClient()));
        if (!browser.isCefBrowserCreated()) {
            return create.apply(null);
        }
        JBCefClient.JSQueryPool pool = browser.getJBCefClient().getJSQueryPool();
        if (pool != null && (slot = pool.getFreeSlot()) != null) {
            return new JBCefJSQuery(browser, slot);
        }
        return create.apply(null);
    }

    public String inject(@Nullable String queryResult) {
        return this.inject(queryResult, "function(response) {}", "function(error_code, error_message) {}");
    }

    public String inject(@Nullable String queryResult, @NotNull String onSuccessCallback, @NotNull String onFailureCallback) {
        if (queryResult != null && queryResult.isEmpty()) {
            queryResult = "''";
        }
        return "window." + this.myFunc.myFuncName + "({request: '' + " + queryResult + ",onSuccess: " + onSuccessCallback + ",onFailure: " + onFailureCallback + "});";
    }

    public void addHandler(final @NotNull Function<String, Response> handler) {
        CefMessageRouterHandlerAdapter cefHandler = new CefMessageRouterHandlerAdapter(){

            public boolean onQuery(CefBrowser browser, CefFrame frame, long query_id, String request, boolean persistent, CefQueryCallback callback) {
                Response response = (Response)handler.apply(request);
                if (callback != null && response != null) {
                    if (response.isSuccess() && response.hasResponse()) {
                        callback.success(response.response());
                    } else {
                        callback.failure(response.errCode(), response.errMsg());
                    }
                } else if (callback != null) {
                    callback.success("");
                }
                return true;
            }
        };
        this.myFunc.myRouter.addHandler((CefMessageRouterHandler)cefHandler, false);
        this.myHandlerMap.put(handler, (CefMessageRouterHandler)cefHandler);
    }

    public void removeHandler(@NotNull Function<String, Response> handler) {
        CefMessageRouterHandler cefHandler = this.myHandlerMap.remove(handler);
        if (cefHandler != null) {
            this.myFunc.myRouter.removeHandler(cefHandler);
        }
    }

    public void dispose() {
        this.myDisposeHelper.dispose(() -> {
            this.myCefClient.removeMessageRouter(this.myFunc.myRouter);
            this.myFunc.myRouter.dispose();
            this.myHandlerMap.clear();
        });
    }

    @Override
    public boolean isDisposed() {
        return this.myDisposeHelper.isDisposed();
    }

    static class JSQueryFunc {
        final CefMessageRouter myRouter;
        final String myFuncName;

        JSQueryFunc(@NotNull JBCefClient client) {
            this(client, client.nextJSQueryIndex(), false);
        }

        JSQueryFunc(@NotNull JBCefClient client, int index, boolean isSlot) {
            String postfix = client.hashCode() + "_" + (isSlot ? "slot_" : "") + index;
            this.myFuncName = "cefQuery_" + postfix;
            CefMessageRouter.CefMessageRouterConfig config = new CefMessageRouter.CefMessageRouterConfig();
            config.jsQueryFunction = this.myFuncName;
            config.jsCancelFunction = "cefQuery_cancel_" + postfix;
            this.myRouter = CefMessageRouter.create((CefMessageRouter.CefMessageRouterConfig)config);
            client.getCefClient().addMessageRouter(this.myRouter);
        }
    }

    public static class Response {
        public static final int ERR_CODE_SUCCESS = 0;
        @Nullable
        private final String myResponse;
        private final int myErrCode;
        @Nullable
        private final String myErrMsg;

        public Response(@Nullable String response) {
            this(response, 0, null);
        }

        public Response(@Nullable String response, int errCode, @Nullable String errMsg) {
            this.myResponse = response;
            this.myErrCode = errCode;
            this.myErrMsg = errMsg;
        }

        @Nullable
        public String response() {
            return this.myResponse;
        }

        public int errCode() {
            return this.myErrCode;
        }

        @Nullable
        public String errMsg() {
            return this.myErrMsg;
        }

        public boolean isSuccess() {
            return this.myErrCode == 0;
        }

        public boolean hasResponse() {
            return this.myResponse != null;
        }
    }
}

