/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.jcef;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Clock;
import com.intellij.ui.jcef.JBCefCookie;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.IntFunction;
import org.cef.callback.CefCookieVisitor;
import org.cef.misc.BoolRef;
import org.cef.network.CefCookie;
import org.cef.network.CefCookieManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JBCefCookieManager {
    private static final int DEFAULT_TIMEOUT_FOR_SYNCHRONOUS_FUNCTION = 200;
    private static final Logger LOG = Logger.getInstance(JBCefCookieManager.class);
    private final ReentrantLock myLock = new ReentrantLock();
    private final ExecutorService myExecutorService = AppExecutorUtil.getAppScheduledExecutorService();
    @NotNull
    private final CefCookieManager myCefCookieManager;

    public JBCefCookieManager() {
        this(CefCookieManager.getGlobalManager());
    }

    private JBCefCookieManager(@NotNull CefCookieManager cefCookieManager) {
        this.myCefCookieManager = cefCookieManager;
    }

    @NotNull
    public CefCookieManager getCefCookieManager() {
        return this.myCefCookieManager;
    }

    @Nullable
    public List<JBCefCookie> getCookies() {
        return this.getCookies(null, false, null);
    }

    @Nullable
    public List<JBCefCookie> getCookies(@NotNull String url) {
        return this.getCookies(url, false, null);
    }

    @Nullable
    public List<JBCefCookie> getCookies(@Nullable String url, @Nullable Boolean includeHttpOnly, @Nullable Integer maxTimeToWait) {
        long startTime = Clock.getTime();
        boolean httpOnly = includeHttpOnly != null ? includeHttpOnly : false;
        int timeout = maxTimeToWait != null ? maxTimeToWait : 200;
        CountDownLatch countDownLatch = new CountDownLatch(1);
        JBCookieVisitor cookieVisitor = new JBCookieVisitor(countDownLatch);
        boolean result = url != null ? this.myCefCookieManager.visitUrlCookies(url, httpOnly, (CefCookieVisitor)cookieVisitor) : this.myCefCookieManager.visitAllCookies((CefCookieVisitor)cookieVisitor);
        if (!result) {
            LOG.debug("Cookies cannot be accessed");
            countDownLatch.countDown();
            return null;
        }
        try {
            result = countDownLatch.await(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            LOG.error("Cookie visiting is interrupted");
        }
        long timeSpent = Clock.getTime() - startTime;
        if (!result) {
            LOG.debug("Timeout for cookie visiting is reached, " + timeSpent + " ms time spent");
        } else {
            LOG.debug("Cookie getting took " + timeSpent + " ms");
        }
        return cookieVisitor.getCookies();
    }

    public boolean setCookie(@NotNull String url, @NotNull JBCefCookie jbCefCookie, boolean doSync) {
        if (doSync) {
            return this.setCookie(url, jbCefCookie, null);
        }
        return this.myCefCookieManager.setCookie(url, jbCefCookie.getCefCookie());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean setCookie(@NotNull String url, @NotNull JBCefCookie jbCefCookie, @Nullable Integer maxTimeToWait) {
        try {
            URI uri = new URI(url);
            String scheme = uri.getScheme();
            String domain = uri.getHost();
            String string = domain = domain.startsWith("www") ? domain : "." + domain;
            if (scheme.equals("http") && jbCefCookie.isSecure()) {
                LOG.warn("Cannot set cookie without secure flag for HTTPS web-site");
                return false;
            }
            if (!domain.contains(jbCefCookie.getDomain())) {
                LOG.warn("Cookie domain `" + jbCefCookie.getDomain() + "` doesn't match URL host `" + domain + "`");
                return false;
            }
        }
        catch (URISyntaxException e) {
            LOG.error((Throwable)e);
            return false;
        }
        int timeout = maxTimeToWait != null ? maxTimeToWait : 200;
        IntFunction<Boolean> checkFunction = timeoutForCheck -> {
            List<JBCefCookie> cookies = this.getCookies(url, null, timeoutForCheck);
            if (cookies == null) {
                return false;
            }
            return cookies.contains(jbCefCookie);
        };
        this.myLock.lock();
        try {
            Future<@NotNull Boolean> future = this.myExecutorService.submit(() -> {
                if (((Boolean)checkFunction.apply(timeout / 2)).booleanValue()) {
                    LOG.debug("Cookie is already set");
                    return true;
                }
                if (!this.myCefCookieManager.setCookie(url, jbCefCookie.getCefCookie())) {
                    LOG.error("Posting task to set cookie is failed");
                    return false;
                }
                while (this.myLock.isLocked()) {
                    boolean result = (Boolean)checkFunction.apply(timeout / 2);
                    if (!result) continue;
                    return true;
                }
                return false;
            });
            try {
                boolean bl = future.get(timeout, TimeUnit.MILLISECONDS);
                return bl;
            }
            catch (TimeoutException e) {
                LOG.error("Cookie setting took more than " + timeout + " ms");
                boolean bl = false;
                this.myLock.unlock();
                return bl;
            }
            catch (InterruptedException e) {
                LOG.error("Cookie setting is interrupted");
                boolean bl = false;
                this.myLock.unlock();
                return bl;
                {
                    catch (Exception e2) {
                        LOG.error((Throwable)e2);
                        boolean bl2 = false;
                        return bl2;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
        }
        finally {
            this.myLock.unlock();
        }
    }

    public boolean deleteCookies(boolean doSync) {
        if (doSync) {
            return this.deleteCookies("", "", timeout -> {
                List<JBCefCookie> cookies = this.getCookies(null, false, timeout);
                if (cookies == null) {
                    return false;
                }
                return cookies.isEmpty();
            }, null);
        }
        return this.myCefCookieManager.deleteCookies("", "");
    }

    public boolean deleteCookies(@NotNull String url, boolean doSync) {
        if (doSync) {
            return this.deleteCookies(url, "", timeout -> {
                List<JBCefCookie> cookies = this.getCookies(url, false, timeout);
                if (cookies == null) {
                    return false;
                }
                return cookies.isEmpty();
            }, null);
        }
        return this.myCefCookieManager.deleteCookies(url, "");
    }

    public boolean deleteCookies(@NotNull String url, @NotNull String cookieName, boolean doSync) {
        if (doSync) {
            return this.deleteCookies(url, cookieName, null);
        }
        return this.myCefCookieManager.deleteCookies(url, cookieName);
    }

    public boolean deleteCookies(@NotNull String url, @NotNull String cookieName, @Nullable Integer maxTimeToWait) {
        IntFunction<Boolean> checkFunction = timeout -> {
            List<JBCefCookie> cookies = this.getCookies(url, false, timeout);
            if (cookies == null) {
                return false;
            }
            return cookies.stream().noneMatch(cefCookie -> cefCookie.getName().equals(cookieName));
        };
        return this.deleteCookies(url, cookieName, checkFunction, maxTimeToWait);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean deleteCookies(@NotNull String url, @NotNull String cookieName, @NotNull IntFunction<Boolean> checkFunction, @Nullable Integer maxTimeToWait) {
        int timeout = maxTimeToWait != null ? maxTimeToWait : 200;
        this.myLock.lock();
        try {
            Future<@NotNull Boolean> future = this.myExecutorService.submit(() -> {
                if (((Boolean)checkFunction.apply(timeout / 2)).booleanValue()) {
                    LOG.debug("No cookies to be deleted");
                    return true;
                }
                if (!this.myCefCookieManager.deleteCookies(url, cookieName)) {
                    LOG.error("Posting task to delete cookies is failed");
                    return false;
                }
                while (this.myLock.isLocked()) {
                    boolean result = (Boolean)checkFunction.apply(timeout / 2);
                    if (!result) continue;
                    return true;
                }
                return false;
            });
            try {
                boolean bl = future.get(timeout, TimeUnit.MILLISECONDS);
                return bl;
            }
            catch (TimeoutException e) {
                LOG.error("Cookie deleting took more than " + timeout + " ms");
                boolean bl = false;
                this.myLock.unlock();
                return bl;
            }
            catch (InterruptedException e) {
                LOG.error("Cookie deleting is interrupted");
                boolean bl = false;
                this.myLock.unlock();
                return bl;
                {
                    catch (Exception e2) {
                        LOG.error((Throwable)e2);
                        boolean bl2 = false;
                        return bl2;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
        }
        finally {
            this.myLock.unlock();
        }
    }

    private static class JBCookieVisitor
    implements CefCookieVisitor {
        final List<JBCefCookie> myCefCookies = new ArrayList<JBCefCookie>();
        final CountDownLatch myCountDownLatch;

        JBCookieVisitor(CountDownLatch countDownLatch) {
            this.myCountDownLatch = countDownLatch;
        }

        public boolean visit(CefCookie cookie, int count, int total, BoolRef delete) {
            this.myCefCookies.add(new JBCefCookie(cookie));
            if (count >= total - 1) {
                this.myCountDownLatch.countDown();
            }
            return true;
        }

        public List<JBCefCookie> getCookies() {
            return this.myCefCookies;
        }
    }
}

