/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.jcef;

import com.intellij.application.options.RegistryManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.ui.jcef.DisposeHelper;
import com.intellij.ui.jcef.JBCefApp;
import com.intellij.ui.jcef.JBCefBrowser;
import com.intellij.ui.jcef.JBCefDisposable;
import com.intellij.ui.jcef.JBCefJSQuery;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.hash.LinkedHashMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;
import org.cef.CefClient;
import org.cef.CefSettings;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefFrame;
import org.cef.callback.CefAuthCallback;
import org.cef.callback.CefBeforeDownloadCallback;
import org.cef.callback.CefContextMenuParams;
import org.cef.callback.CefDownloadItem;
import org.cef.callback.CefDownloadItemCallback;
import org.cef.callback.CefDragData;
import org.cef.callback.CefFileDialogCallback;
import org.cef.callback.CefJSDialogCallback;
import org.cef.callback.CefMenuModel;
import org.cef.callback.CefRequestCallback;
import org.cef.handler.CefContextMenuHandler;
import org.cef.handler.CefDialogHandler;
import org.cef.handler.CefDisplayHandler;
import org.cef.handler.CefDownloadHandler;
import org.cef.handler.CefDragHandler;
import org.cef.handler.CefFocusHandler;
import org.cef.handler.CefJSDialogHandler;
import org.cef.handler.CefKeyboardHandler;
import org.cef.handler.CefLifeSpanHandler;
import org.cef.handler.CefLoadHandler;
import org.cef.handler.CefRequestHandler;
import org.cef.handler.CefResourceRequestHandler;
import org.cef.misc.BoolRef;
import org.cef.network.CefRequest;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JBCefClient
implements JBCefDisposable {
    private static final Logger LOG = Logger.getInstance(JBCefClient.class);
    @ApiStatus.Experimental
    public static final String JBCEFCLIENT_JSQUERY_POOL_SIZE_PROP = "JBCefClient.JSQuery.poolSize";
    private static final int JS_QUERY_SLOT_POOL_DEF_SIZE = RegistryManager.getInstance().intValue("ide.browser.jcef.jsQueryPoolSize");
    private static final int JS_QUERY_SLOT_POOL_MAX_SIZE = 10000;
    @NotNull
    private final CefClient myCefClient;
    @NotNull
    private final DisposeHelper myDisposeHelper = new DisposeHelper();
    @NotNull
    private final Map<String, Object> myProperties = Collections.synchronizedMap(new HashMap());
    @Nullable
    private JSQueryPool myJSQueryPool;
    @NotNull
    private final AtomicInteger myJSQueryCounter = new AtomicInteger(0);
    private final HandlerSupport<CefContextMenuHandler> myContextMenuHandler = new HandlerSupport();
    private final HandlerSupport<CefDialogHandler> myDialogHandler = new HandlerSupport();
    private final HandlerSupport<CefDisplayHandler> myDisplayHandler = new HandlerSupport();
    private final HandlerSupport<CefDownloadHandler> myDownloadHandler = new HandlerSupport();
    private final HandlerSupport<CefDragHandler> myDragHandler = new HandlerSupport();
    private final HandlerSupport<CefFocusHandler> myFocusHandler = new HandlerSupport();
    private final HandlerSupport<CefJSDialogHandler> myJSDialogHandler = new HandlerSupport();
    private final HandlerSupport<CefKeyboardHandler> myKeyboardHandler = new HandlerSupport();
    private final HandlerSupport<CefLifeSpanHandler> myLifeSpanHandler = new HandlerSupport();
    private final HandlerSupport<CefLoadHandler> myLoadHandler = new HandlerSupport();
    private final HandlerSupport<CefRequestHandler> myRequestHandler = new HandlerSupport();

    JBCefClient(@NotNull CefClient client) {
        this.myCefClient = client;
        Disposer.register((Disposable)JBCefApp.getInstance().getDisposable(), (Disposable)this);
    }

    @NotNull
    public CefClient getCefClient() {
        return this.myCefClient;
    }

    public void dispose() {
        this.myDisposeHelper.dispose(() -> {
            try {
                this.myCefClient.dispose();
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
            }
        });
    }

    @Override
    public boolean isDisposed() {
        return this.myDisposeHelper.isDisposed();
    }

    public void addProperty(@NotNull String name, @NotNull Object value) {
        this.myProperties.put(name, value);
    }

    public void removeProperty(@NotNull String name) {
        this.myProperties.remove(name);
    }

    @Nullable
    public Object getProperty(@NotNull String name) {
        return this.myProperties.get(name);
    }

    @Nullable
    synchronized JSQueryPool getJSQueryPool() {
        return this.myJSQueryPool;
    }

    synchronized void notifyBrowserCreated(@NotNull JBCefBrowser browser) {
        if (this.myJSQueryPool == null) {
            this.myJSQueryPool = JSQueryPool.create(this);
        }
    }

    int nextJSQueryIndex() {
        return this.myJSQueryCounter.incrementAndGet();
    }

    public JBCefClient addContextMenuHandler(@NotNull CefContextMenuHandler handler, @NotNull CefBrowser browser) {
        return this.myContextMenuHandler.add(handler, browser, () -> this.myCefClient.addContextMenuHandler(new CefContextMenuHandler(){

            public void onBeforeContextMenu(CefBrowser browser, CefFrame frame, CefContextMenuParams params, CefMenuModel model) {
                JBCefClient.this.myContextMenuHandler.handle(browser, handler -> handler.onBeforeContextMenu(browser, frame, params, model));
            }

            public boolean onContextMenuCommand(CefBrowser browser, CefFrame frame, CefContextMenuParams params, int commandId, int eventFlags) {
                return JBCefClient.this.myContextMenuHandler.handleBoolean(browser, handler -> handler.onContextMenuCommand(browser, frame, params, commandId, eventFlags));
            }

            public void onContextMenuDismissed(CefBrowser browser, CefFrame frame) {
                JBCefClient.this.myContextMenuHandler.handle(browser, handler -> handler.onContextMenuDismissed(browser, frame));
            }
        }));
    }

    public void removeContextMenuHandler(@NotNull CefContextMenuHandler handler, @NotNull CefBrowser browser) {
        this.myContextMenuHandler.remove(handler, browser, () -> this.myCefClient.removeContextMenuHandler());
    }

    public JBCefClient addDialogHandler(@NotNull CefDialogHandler handler, @NotNull CefBrowser browser) {
        return this.myDialogHandler.add(handler, browser, () -> this.myCefClient.addDialogHandler(new CefDialogHandler(){

            public boolean onFileDialog(CefBrowser browser, CefDialogHandler.FileDialogMode mode, String title, String defaultFilePath, Vector<String> acceptFilters, int selectedAcceptFilter, CefFileDialogCallback callback) {
                return JBCefClient.this.myDialogHandler.handleBoolean(browser, handler -> handler.onFileDialog(browser, mode, title, defaultFilePath, acceptFilters, selectedAcceptFilter, callback));
            }
        }));
    }

    public void removeDialogHandler(@NotNull CefDialogHandler handler, @NotNull CefBrowser browser) {
        this.myDialogHandler.remove(handler, browser, () -> this.myCefClient.removeDialogHandler());
    }

    public JBCefClient addDisplayHandler(@NotNull CefDisplayHandler handler, @NotNull CefBrowser browser) {
        return this.myDisplayHandler.add(handler, browser, () -> this.myCefClient.addDisplayHandler(new CefDisplayHandler(){

            public void onAddressChange(CefBrowser browser, CefFrame frame, String url) {
                JBCefClient.this.myDisplayHandler.handle(browser, handler -> handler.onAddressChange(browser, frame, url));
            }

            public void onTitleChange(CefBrowser browser, String title) {
                JBCefClient.this.myDisplayHandler.handle(browser, handler -> handler.onTitleChange(browser, title));
            }

            public boolean onTooltip(CefBrowser browser, String text) {
                return JBCefClient.this.myDisplayHandler.handleBoolean(browser, handler -> handler.onTooltip(browser, text));
            }

            public void onStatusMessage(CefBrowser browser, String value) {
                JBCefClient.this.myDisplayHandler.handle(browser, handler -> handler.onStatusMessage(browser, value));
            }

            public boolean onConsoleMessage(CefBrowser browser, CefSettings.LogSeverity level, String message, String source, int line) {
                return JBCefClient.this.myDisplayHandler.handleBoolean(browser, handler -> handler.onConsoleMessage(browser, level, message, source, line));
            }
        }));
    }

    public void removeDisplayHandler(@NotNull CefDisplayHandler handler, @NotNull CefBrowser browser) {
        this.myDisplayHandler.remove(handler, browser, () -> this.myCefClient.removeDisplayHandler());
    }

    public JBCefClient addDownloadHandler(@NotNull CefDownloadHandler handler, @NotNull CefBrowser browser) {
        return this.myDownloadHandler.add(handler, browser, () -> this.myCefClient.addDownloadHandler(new CefDownloadHandler(){

            public void onBeforeDownload(CefBrowser browser, CefDownloadItem downloadItem, String suggestedName, CefBeforeDownloadCallback callback) {
                JBCefClient.this.myDownloadHandler.handle(browser, handler -> handler.onBeforeDownload(browser, downloadItem, suggestedName, callback));
            }

            public void onDownloadUpdated(CefBrowser browser, CefDownloadItem downloadItem, CefDownloadItemCallback callback) {
                JBCefClient.this.myDownloadHandler.handle(browser, handler -> handler.onDownloadUpdated(browser, downloadItem, callback));
            }
        }));
    }

    public void removeDownloadHandle(@NotNull CefDownloadHandler handler, @NotNull CefBrowser browser) {
        this.myDownloadHandler.remove(handler, browser, () -> this.myCefClient.removeDownloadHandler());
    }

    public JBCefClient addDragHandler(@NotNull CefDragHandler handler, @NotNull CefBrowser browser) {
        return this.myDragHandler.add(handler, browser, () -> this.myCefClient.addDragHandler(new CefDragHandler(){

            public boolean onDragEnter(CefBrowser browser, CefDragData dragData, int mask) {
                return JBCefClient.this.myDragHandler.handleBoolean(browser, handler -> handler.onDragEnter(browser, dragData, mask));
            }
        }));
    }

    public void removeDragHandler(@NotNull CefDragHandler handler, @NotNull CefBrowser browser) {
        this.myDragHandler.remove(handler, browser, () -> this.myCefClient.removeDragHandler());
    }

    public JBCefClient addFocusHandler(@NotNull CefFocusHandler handler, @NotNull CefBrowser browser) {
        return this.myFocusHandler.add(handler, browser, () -> this.myCefClient.addFocusHandler(new CefFocusHandler(){

            public void onTakeFocus(CefBrowser browser, boolean next) {
                JBCefClient.this.myFocusHandler.handle(browser, handler -> handler.onTakeFocus(browser, next));
            }

            public boolean onSetFocus(CefBrowser browser, CefFocusHandler.FocusSource source) {
                return JBCefClient.this.myFocusHandler.handleBoolean(browser, handler -> handler.onSetFocus(browser, source));
            }

            public void onGotFocus(CefBrowser browser) {
                JBCefClient.this.myFocusHandler.handle(browser, handler -> handler.onGotFocus(browser));
            }
        }));
    }

    public void removeFocusHandler(@NotNull CefFocusHandler handler, @NotNull CefBrowser browser) {
        this.myFocusHandler.remove(handler, browser, () -> this.myCefClient.removeFocusHandler());
    }

    public JBCefClient addJSDialogHandler(@NotNull CefJSDialogHandler handler, @NotNull CefBrowser browser) {
        return this.myJSDialogHandler.add(handler, browser, () -> this.myCefClient.addJSDialogHandler(new CefJSDialogHandler(){

            public boolean onJSDialog(CefBrowser browser, String origin_url, CefJSDialogHandler.JSDialogType dialog_type, String message_text, String default_prompt_text, CefJSDialogCallback callback, BoolRef suppress_message) {
                return JBCefClient.this.myJSDialogHandler.handleBoolean(browser, handler -> handler.onJSDialog(browser, origin_url, dialog_type, message_text, default_prompt_text, callback, suppress_message));
            }

            public boolean onBeforeUnloadDialog(CefBrowser browser, String message_text, boolean is_reload, CefJSDialogCallback callback) {
                return JBCefClient.this.myJSDialogHandler.handleBoolean(browser, handler -> handler.onBeforeUnloadDialog(browser, message_text, is_reload, callback));
            }

            public void onResetDialogState(CefBrowser browser) {
                JBCefClient.this.myJSDialogHandler.handle(browser, handler -> handler.onResetDialogState(browser));
            }

            public void onDialogClosed(CefBrowser browser) {
                JBCefClient.this.myJSDialogHandler.handle(browser, handler -> handler.onDialogClosed(browser));
            }
        }));
    }

    public void removeJSDialogHandler(@NotNull CefJSDialogHandler handler, @NotNull CefBrowser browser) {
        this.myJSDialogHandler.remove(handler, browser, () -> this.myCefClient.removeJSDialogHandler());
    }

    public JBCefClient addKeyboardHandler(@NotNull CefKeyboardHandler handler, @NotNull CefBrowser browser) {
        return this.myKeyboardHandler.add(handler, browser, () -> this.myCefClient.addKeyboardHandler(new CefKeyboardHandler(){

            public boolean onPreKeyEvent(CefBrowser browser, CefKeyboardHandler.CefKeyEvent event, BoolRef is_keyboard_shortcut) {
                return JBCefClient.this.myKeyboardHandler.handleBoolean(browser, handler -> handler.onPreKeyEvent(browser, event, is_keyboard_shortcut));
            }

            public boolean onKeyEvent(CefBrowser browser, CefKeyboardHandler.CefKeyEvent event) {
                return JBCefClient.this.myKeyboardHandler.handleBoolean(browser, handler -> handler.onKeyEvent(browser, event));
            }
        }));
    }

    public void removeKeyboardHandler(@NotNull CefKeyboardHandler handler, @NotNull CefBrowser browser) {
        this.myKeyboardHandler.remove(handler, browser, () -> this.myCefClient.removeKeyboardHandler());
    }

    public JBCefClient addLifeSpanHandler(@NotNull CefLifeSpanHandler handler, @NotNull CefBrowser browser) {
        return this.myLifeSpanHandler.add(handler, browser, () -> this.myCefClient.addLifeSpanHandler(new CefLifeSpanHandler(){

            public boolean onBeforePopup(CefBrowser browser, CefFrame frame, String target_url, String target_frame_name) {
                return JBCefClient.this.myLifeSpanHandler.handleBoolean(browser, handler -> handler.onBeforePopup(browser, frame, target_url, target_frame_name));
            }

            public void onAfterCreated(CefBrowser browser) {
                JBCefClient.this.myLifeSpanHandler.handle(browser, handler -> handler.onAfterCreated(browser));
            }

            public void onAfterParentChanged(CefBrowser browser) {
                JBCefClient.this.myLifeSpanHandler.handle(browser, handler -> handler.onAfterParentChanged(browser));
            }

            public boolean doClose(CefBrowser browser) {
                return JBCefClient.this.myLifeSpanHandler.handleBoolean(browser, handler -> handler.doClose(browser));
            }

            public void onBeforeClose(CefBrowser browser) {
                JBCefClient.this.myLifeSpanHandler.handle(browser, handler -> handler.onBeforeClose(browser));
            }
        }));
    }

    public void removeLifeSpanHandler(@NotNull CefLifeSpanHandler handler, @NotNull CefBrowser browser) {
        this.myLifeSpanHandler.remove(handler, browser, () -> this.myCefClient.removeLifeSpanHandler());
    }

    public JBCefClient addLoadHandler(@NotNull CefLoadHandler handler, @NotNull CefBrowser browser) {
        return this.myLoadHandler.add(handler, browser, () -> this.myCefClient.addLoadHandler(new CefLoadHandler(){

            public void onLoadingStateChange(CefBrowser browser, boolean isLoading, boolean canGoBack, boolean canGoForward) {
                JBCefClient.this.myLoadHandler.handle(browser, handler -> handler.onLoadingStateChange(browser, isLoading, canGoBack, canGoForward));
            }

            public void onLoadStart(CefBrowser browser, CefFrame frame, CefRequest.TransitionType transitionType) {
                JBCefClient.this.myLoadHandler.handle(browser, handler -> handler.onLoadStart(browser, frame, transitionType));
            }

            public void onLoadEnd(CefBrowser browser, CefFrame frame, int httpStatusCode) {
                JBCefClient.this.myLoadHandler.handle(browser, handler -> handler.onLoadEnd(browser, frame, httpStatusCode));
            }

            public void onLoadError(CefBrowser browser, CefFrame frame, CefLoadHandler.ErrorCode errorCode, String errorText, String failedUrl) {
                JBCefClient.this.myLoadHandler.handle(browser, handler -> handler.onLoadError(browser, frame, errorCode, errorText, failedUrl));
            }
        }));
    }

    public void removeLoadHandler(@NotNull CefLoadHandler handler, @NotNull CefBrowser browser) {
        this.myLoadHandler.remove(handler, browser, () -> this.myCefClient.removeLoadHandler());
    }

    public JBCefClient addRequestHandler(@NotNull CefRequestHandler handler, @NotNull CefBrowser browser) {
        return this.myRequestHandler.add(handler, browser, () -> this.myCefClient.addRequestHandler(new CefRequestHandler(){

            public boolean onBeforeBrowse(CefBrowser browser, CefFrame frame, CefRequest request, boolean user_gesture, boolean is_redirect) {
                return JBCefClient.this.myRequestHandler.handleBoolean(browser, handler -> handler.onBeforeBrowse(browser, frame, request, user_gesture, is_redirect));
            }

            @Nullable
            public CefResourceRequestHandler getResourceRequestHandler(CefBrowser browser, CefFrame frame, CefRequest request, boolean isNavigation, boolean isDownload, String requestInitiator, BoolRef disableDefaultHandling) {
                return JBCefClient.this.myRequestHandler.handle(browser, handler -> handler.getResourceRequestHandler(browser, frame, request, isNavigation, isDownload, requestInitiator, disableDefaultHandling));
            }

            public boolean getAuthCredentials(CefBrowser browser, String origin_url, boolean isProxy, String host, int port, String realm, String scheme, CefAuthCallback callback) {
                return JBCefClient.this.myRequestHandler.handleBoolean(browser, handler -> handler.getAuthCredentials(browser, origin_url, isProxy, host, port, realm, scheme, callback));
            }

            public boolean onQuotaRequest(CefBrowser browser, String origin_url, long new_size, CefRequestCallback callback) {
                return JBCefClient.this.myRequestHandler.handleBoolean(browser, handler -> handler.onQuotaRequest(browser, origin_url, new_size, callback));
            }

            public boolean onCertificateError(CefBrowser browser, CefLoadHandler.ErrorCode cert_error, String request_url, CefRequestCallback callback) {
                return JBCefClient.this.myRequestHandler.handleBoolean(browser, handler -> handler.onCertificateError(browser, cert_error, request_url, callback));
            }

            public void onPluginCrashed(CefBrowser browser, String pluginPath) {
                JBCefClient.this.myRequestHandler.handle(browser, handler -> handler.onPluginCrashed(browser, pluginPath));
            }

            public void onRenderProcessTerminated(CefBrowser browser, CefRequestHandler.TerminationStatus status) {
                JBCefClient.this.myRequestHandler.handle(browser, handler -> handler.onRenderProcessTerminated(browser, status));
            }
        }));
    }

    public void removeRequestHandler(@NotNull CefRequestHandler handler, @NotNull CefBrowser browser) {
        this.myRequestHandler.remove(handler, browser, () -> this.myCefClient.removeRequestHandler());
    }

    private static interface HandlerRunnable<T> {
        public void handle(T var1);
    }

    private static interface HandlerCallable<T, R> {
        @Nullable
        public R handle(T var1);
    }

    private class HandlerSupport<T> {
        private volatile Map<CefBrowser, List<T>> myMap;

        private HandlerSupport() {
        }

        private synchronized void syncInitMap() {
            if (this.myMap == null) {
                this.myMap = Collections.synchronizedMap(new LinkedHashMap());
            }
        }

        private synchronized List<T> syncInitList(@NotNull CefBrowser browser, @NotNull Runnable onInit) {
            List<Object> list = this.myMap.get(browser);
            if (list == null) {
                if (this.myMap.isEmpty()) {
                    onInit.run();
                }
                list = Collections.synchronizedList(new LinkedList());
                this.myMap.put(browser, list);
            }
            return list;
        }

        private synchronized void syncRemoveFromMap(@NotNull List<T> list, @NotNull CefBrowser browser, @NotNull Runnable onClear) {
            if (list.isEmpty()) {
                this.myMap.remove(browser);
                if (this.myMap.isEmpty()) {
                    onClear.run();
                }
            }
        }

        public JBCefClient add(@NotNull T handler, @NotNull CefBrowser browser, @NotNull Runnable onInit) {
            List<T> list;
            if (this.myMap == null) {
                this.syncInitMap();
            }
            if ((list = this.myMap.get(browser)) == null) {
                list = this.syncInitList(browser, onInit);
            }
            list.add(handler);
            return JBCefClient.this;
        }

        public void remove(@NotNull T handler, @NotNull CefBrowser browser, @NotNull Runnable onClear) {
            List<T> list;
            if (this.myMap != null && (list = this.myMap.get(browser)) != null) {
                list.remove(handler);
                if (list.isEmpty()) {
                    this.syncRemoveFromMap(list, browser, onClear);
                }
            }
        }

        public void clear() {
            if (this.myMap != null) {
                this.myMap.clear();
            }
        }

        @Nullable
        public List<T> get(@NotNull CefBrowser browser) {
            return this.myMap != null ? this.myMap.get(browser) : null;
        }

        @Nullable
        public <R> R handle(@NotNull CefBrowser browser, @NotNull HandlerCallable<T, R> callable) {
            List<Object> list = this.get(browser);
            if (list == null) {
                return null;
            }
            Ref lastResult = new Ref(null);
            list.forEach(handler -> lastResult.set(callable.handle(handler)));
            return (R)lastResult.get();
        }

        public <R> boolean handleBoolean(@NotNull CefBrowser browser, @NotNull HandlerCallable<T, Boolean> callable) {
            return (Boolean)ObjectUtils.notNull((Object)this.handle(browser, callable), (Object)Boolean.FALSE);
        }

        public void handle(@NotNull CefBrowser browser, @NotNull HandlerRunnable<T> runnable) {
            List<Object> list = this.get(browser);
            if (list == null) {
                return;
            }
            list.forEach(handler -> runnable.handle(handler));
        }
    }

    static class JSQueryPool {
        private final JBCefJSQuery.JSQueryFunc[] pool;
        private int currentFreeSlot;

        @Nullable
        static JSQueryPool create(@NotNull JBCefClient client) {
            int poolSize;
            Object size = client.getProperty(JBCefClient.JBCEFCLIENT_JSQUERY_POOL_SIZE_PROP);
            int n = poolSize = size instanceof Integer ? (Integer)size : JS_QUERY_SLOT_POOL_DEF_SIZE;
            if (poolSize > 0) {
                poolSize = Math.min(poolSize, 10000);
                return new JSQueryPool(client, poolSize);
            }
            return null;
        }

        JSQueryPool(@NotNull JBCefClient client, int poolSize) {
            this.pool = new JBCefJSQuery.JSQueryFunc[poolSize];
            for (int i = 0; i < this.pool.length; ++i) {
                this.pool[i] = new JBCefJSQuery.JSQueryFunc(client, i, true);
            }
        }

        @Nullable
        public JBCefJSQuery.JSQueryFunc getFreeSlot() {
            if (this.currentFreeSlot >= this.pool.length) {
                LOG.warn("JavaScript query pool is over [size: " + this.pool.length + "]", new Throwable());
                return null;
            }
            return this.pool[this.currentFreeSlot++];
        }
    }
}

