/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components.fields.valueEditors;

import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.fields.valueEditors.AbstractValueEditor;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TextFieldValueEditor<T>
extends AbstractValueEditor<T> {
    private final JTextField myField;

    public TextFieldValueEditor(@NotNull JTextField field, @Nullable String valueName, @NotNull T defaultValue) {
        super(valueName, defaultValue);
        this.myField = field;
        this.myField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                String errorText = TextFieldValueEditor.this.validateTextOnChange(TextFieldValueEditor.this.myField.getText(), e);
                TextFieldValueEditor.this.highlightState(StringUtil.isEmpty((String)errorText));
                if (StringUtil.isNotEmpty((String)errorText)) {
                    TextFieldValueEditor.this.setErrorText(errorText);
                }
            }
        });
    }

    protected String validateTextOnChange(String text, DocumentEvent e) {
        try {
            Object newValue = this.parseValue(text);
            this.fireValueChanged(newValue);
            return null;
        }
        catch (InvalidDataException ex) {
            return ex.getMessage();
        }
    }

    private void highlightState(boolean isValid) {
        this.myField.putClientProperty("JComponent.outline", isValid ? null : "error");
    }

    protected void setErrorText(@NotNull String errorText) {
    }

    @Override
    public String getValueText() {
        return this.myField.getText();
    }

    @Override
    public void setValueText(@NotNull String text) {
        this.myField.setText(text);
    }
}

