/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components.breadcrumbs;

import com.intellij.psi.PsiElement;
import com.intellij.ui.breadcrumbs.BreadcrumbsProvider;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Crumb {
    default public Icon getIcon() {
        return null;
    }

    default public String getText() {
        return this.toString();
    }

    @Nullable
    default public String getTooltip() {
        return null;
    }

    @NotNull
    default public List<? extends Action> getContextActions() {
        return Collections.emptyList();
    }

    public static class Impl
    implements Crumb {
        private final Icon icon;
        private final String text;
        private final String tooltip;
        @NotNull
        private final List<? extends Action> actions;

        public Impl(@NotNull BreadcrumbsProvider provider, @NotNull PsiElement element) {
            this(provider.getElementIcon(element), provider.getElementInfo(element), provider.getElementTooltip(element), provider.getContextActions(element));
        }

        public Impl(Icon icon, String text, String tooltip, Action ... actions) {
            this(icon, text, tooltip, actions == null || actions.length == 0 ? Collections.emptyList() : Arrays.asList(actions));
        }

        public Impl(Icon icon, String text, String tooltip, @NotNull List<? extends Action> actions) {
            this.icon = icon;
            this.text = text;
            this.tooltip = tooltip;
            this.actions = actions;
        }

        @Override
        public Icon getIcon() {
            return this.icon;
        }

        @Override
        public String getTooltip() {
            return this.tooltip;
        }

        @Override
        @NotNull
        public List<? extends Action> getContextActions() {
            return this.actions;
        }

        public String toString() {
            return this.text;
        }
    }
}

