/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StatusText;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;

class TextComponentEmptyText
extends StatusText {
    private final JTextComponent myOwner;
    private String myStatusTriggerText = "";

    TextComponentEmptyText(JTextComponent owner) {
        super(owner);
        this.myOwner = owner;
        this.clear();
        this.myOwner.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                TextComponentEmptyText.this.myOwner.repaint();
            }

            @Override
            public void focusLost(FocusEvent e) {
                TextComponentEmptyText.this.myOwner.repaint();
            }
        });
    }

    public void setTextToTriggerStatus(@NotNull String defaultText) {
        this.myStatusTriggerText = defaultText;
    }

    @NotNull
    public String getStatusTriggerText() {
        return this.myStatusTriggerText;
    }

    public void paintStatusText(Graphics g) {
        if (!this.isFontSet()) {
            this.setFont(this.myOwner.getFont());
        }
        this.paint(this.myOwner, g);
    }

    @Override
    protected boolean isStatusVisible() {
        return this.myOwner.getText().equals(this.myStatusTriggerText) && !this.myOwner.isFocusOwner();
    }

    @Override
    protected Rectangle getTextComponentBound() {
        Rectangle b = this.myOwner.getBounds();
        Insets insets = (Insets)ObjectUtils.notNull((Object)this.myOwner.getInsets(), (Object)JBUI.emptyInsets());
        Insets margin = (Insets)ObjectUtils.notNull((Object)this.myOwner.getMargin(), (Object)JBUI.emptyInsets());
        Insets ipad = this.getComponent().getIpad();
        int left = insets.left + margin.left - ipad.left;
        int right = insets.right + margin.right - ipad.right;
        int top = insets.top + margin.top - ipad.top;
        int bottom = insets.bottom + margin.bottom - ipad.bottom;
        return new Rectangle(left, top, b.width - left - right, b.height - top - bottom);
    }

    @Override
    @NotNull
    protected Rectangle adjustComponentBounds(@NotNull JComponent component, @NotNull Rectangle bounds) {
        Dimension size = component.getPreferredSize();
        return component == this.getComponent() ? new Rectangle(bounds.x, bounds.y, size.width, bounds.height) : new Rectangle(bounds.x + bounds.width - size.width, bounds.y, size.width, bounds.height);
    }
}

