/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.util.NotNullFunction;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public class SelectionAwareListCellRenderer<T>
implements ListCellRenderer<T> {
    private final NotNullFunction<? super T, ? extends JComponent> myFun;

    public SelectionAwareListCellRenderer(NotNullFunction<? super T, ? extends JComponent> fun) {
        this.myFun = fun;
    }

    @Override
    @NotNull
    public Component getListCellRendererComponent(@NotNull JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JComponent comp = (JComponent)this.myFun.fun(value);
        comp.setOpaque(true);
        if (isSelected) {
            comp.setBackground(list.getSelectionBackground());
            comp.setForeground(list.getSelectionForeground());
        } else {
            comp.setBackground(list.getBackground());
            comp.setForeground(list.getForeground());
        }
        for (JLabel label : UIUtil.findComponentsOfType((JComponent)comp, JLabel.class)) {
            label.setForeground(UIUtil.getListForeground((boolean)isSelected));
        }
        return comp;
    }
}

