/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public abstract class ColoredListCellRenderer<T>
extends SimpleColoredComponent
implements ListCellRenderer<T> {
    protected boolean mySelected;
    protected Color myForeground;
    protected Color mySelectionForeground;

    public ColoredListCellRenderer() {
        this.setFocusBorderAroundIcon(true);
        this.getIpad().right = UIUtil.isUnderWin10LookAndFeel() ? 0 : JBUIScale.scale((int)UIUtil.getListCellHPadding());
        this.getIpad().left = this.getIpad().right;
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends T> list, T value, int index, boolean selected, boolean hasFocus) {
        this.clear();
        this.setFont(list.getFont());
        this.mySelected = selected;
        this.myForeground = this.isEnabled() ? list.getForeground() : UIUtil.getLabelDisabledForeground();
        this.mySelectionForeground = list.getSelectionForeground();
        if (UIUtil.isUnderWin10LookAndFeel()) {
            this.setBackground(selected ? list.getSelectionBackground() : list.getBackground());
        } else {
            this.setBackground(selected ? list.getSelectionBackground() : null);
        }
        this.setPaintFocusBorder(hasFocus);
        this.customizeCellRenderer(list, value, index, selected, hasFocus);
        return this;
    }

    @Override
    public final void append(@NotNull String fragment, @NotNull SimpleTextAttributes attributes, boolean isMainText) {
        if (this.mySelected) {
            super.append(fragment, new SimpleTextAttributes(attributes.getStyle(), this.mySelectionForeground), isMainText);
        } else if (attributes.getFgColor() == null) {
            super.append(fragment, attributes.derive(-1, this.myForeground, null, null), isMainText);
        } else {
            super.append(fragment, attributes, isMainText);
        }
    }

    @Override
    void revalidateAndRepaint() {
    }

    @Override
    @NotNull
    public Dimension getPreferredSize() {
        Font oldFont = this.getFont();
        if (oldFont == null) {
            this.setFont(UIUtil.getListFont());
        }
        Dimension result = super.getPreferredSize();
        if (oldFont == null) {
            this.setFont(null);
        }
        return UIUtil.updateListRowHeight((Dimension)result);
    }

    protected abstract void customizeCellRenderer(@NotNull JList<? extends T> var1, T var2, int var3, boolean var4, boolean var5);

    @Override
    public void validate() {
    }

    @Override
    public void invalidate() {
    }

    @Override
    public void repaint() {
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void repaint(long tm, int x, int y, int width, int height) {
    }

    @Override
    public void repaint(Rectangle r) {
    }

    @Override
    public void firePropertyChange(String propertyName, byte oldValue, byte newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, char oldValue, char newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, short oldValue, short newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, int oldValue, int newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, long oldValue, long newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, float oldValue, float newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, double oldValue, double newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }
}

