/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.configuration.deployment;

import com.intellij.openapi.project.Project;
import com.intellij.remoteServer.configuration.deployment.DeploymentSource;
import com.intellij.remoteServer.configuration.deployment.DeploymentSourceType;
import java.io.File;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SingletonDeploymentSourceType
extends DeploymentSourceType<DeploymentSource> {
    @Nls
    private final String myPresentableName;
    private final SingletonDeploymentSource mySourceInstance;

    public SingletonDeploymentSourceType(@NotNull String id, @NotNull @Nls String name, @NotNull Icon icon) {
        super(id);
        this.myPresentableName = name;
        this.mySourceInstance = new SingletonDeploymentSource(icon, this.getClass());
    }

    protected static <T extends SingletonDeploymentSourceType> T findExtension(@NotNull Class<? extends T> clazz) {
        return (T)((SingletonDeploymentSourceType)DeploymentSourceType.EP_NAME.findExtension(clazz));
    }

    @NotNull
    public DeploymentSource getSingletonSource() {
        return this.mySourceInstance;
    }

    @Override
    public void save(@NotNull DeploymentSource source, @NotNull Element tag) {
    }

    @Override
    @NotNull
    public DeploymentSource load(@NotNull Element tag, @NotNull Project project) {
        return this.getSingletonSource();
    }

    @Nls
    @NotNull
    public final String getPresentableName() {
        return this.myPresentableName;
    }

    private static class SingletonDeploymentSource
    implements DeploymentSource {
        private final Class<? extends SingletonDeploymentSourceType> myTypeClass;
        private final Icon myIcon;

        SingletonDeploymentSource(@NotNull Icon icon, @NotNull Class<? extends SingletonDeploymentSourceType> typeClass) {
            this.myIcon = icon;
            this.myTypeClass = typeClass;
        }

        @Override
        @Nullable
        public final File getFile() {
            return null;
        }

        @Override
        @Nullable
        public final String getFilePath() {
            return null;
        }

        @Override
        public final boolean isArchive() {
            return false;
        }

        @Override
        public final boolean isValid() {
            return true;
        }

        @Override
        @Nullable
        public Icon getIcon() {
            return this.myIcon;
        }

        @Override
        @NotNull
        public final String getPresentableName() {
            return this.getType().getPresentableName();
        }

        @NotNull
        public SingletonDeploymentSourceType getType() {
            return SingletonDeploymentSourceType.findExtension(this.myTypeClass);
        }
    }
}

