/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MultiLineLabelUI;
import com.intellij.openapi.util.NlsContexts;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefactoringMessageDialog
extends DialogWrapper {
    private final String myMessage;
    private final String myHelpTopic;
    private final Icon myIcon;
    private final boolean myIsCancelButtonVisible;

    public RefactoringMessageDialog(@NlsContexts.DialogTitle String title, @Nls String message, @NonNls String helpTopic, @NonNls String iconId, boolean showCancelButton, Project project) {
        super(project, false);
        this.setTitle(title);
        this.myMessage = message;
        this.myHelpTopic = helpTopic;
        this.myIsCancelButtonVisible = showCancelButton;
        this.myIcon = UIManager.getIcon(iconId);
        this.init();
    }

    @Override
    protected Action @NotNull [] createActions() {
        ArrayList<Action> actions = new ArrayList<Action>();
        actions.add(this.getOKAction());
        if (this.myIsCancelButtonVisible) {
            actions.add(this.getCancelAction());
        }
        if (this.myHelpTopic != null) {
            actions.add(this.getHelpAction());
        }
        return actions.toArray(new Action[0]);
    }

    @Override
    protected JComponent createNorthPanel() {
        JLabel label = new JLabel(this.myMessage);
        label.setUI(new MultiLineLabelUI());
        JPanel panel2 = new JPanel(new BorderLayout(10, 0));
        if (this.myIcon != null) {
            panel2.add((Component)new JLabel(this.myIcon), "West");
            panel2.add((Component)label, "Center");
        } else {
            panel2.add((Component)label, "West");
        }
        return panel2;
    }

    @Override
    protected JComponent createCenterPanel() {
        return null;
    }

    @Override
    @Nullable
    protected String getHelpId() {
        return this.myHelpTopic;
    }
}

