/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b7\u0018\u00002\u00020\u0001:\u0002\u0013\u0014B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u0004\u0018\u00010\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001f\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b\u0018\u00010\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u0082\u0001\u0002\u0015\u0016\u00a8\u0006\u0017"}, d2={"Lcom/intellij/psi/util/StringEntry;", "", "()V", "host", "Lcom/intellij/psi/PsiLanguageInjectionHost;", "getHost", "()Lcom/intellij/psi/PsiLanguageInjectionHost;", "range", "Lcom/intellij/openapi/util/TextRange;", "getRange", "()Lcom/intellij/openapi/util/TextRange;", "rangeAlignedToHost", "Lkotlin/Pair;", "getRangeAlignedToHost", "()Lkotlin/Pair;", "sourcePsi", "Lcom/intellij/psi/PsiElement;", "getSourcePsi", "()Lcom/intellij/psi/PsiElement;", "Known", "Unknown", "Lcom/intellij/psi/util/StringEntry$Known;", "Lcom/intellij/psi/util/StringEntry$Unknown;", "intellij.platform.lang"})
@ApiStatus.Experimental
public abstract class StringEntry {
    @Nullable
    public abstract PsiElement getSourcePsi();

    @NotNull
    public abstract TextRange getRange();

    @Nullable
    public final PsiLanguageInjectionHost getHost() {
        PsiLanguageInjectionHost psiLanguageInjectionHost;
        PsiElement psiElement = this.getSourcePsi();
        if (!(psiElement instanceof PsiLanguageInjectionHost)) {
            psiElement = null;
        }
        if ((psiLanguageInjectionHost = (PsiLanguageInjectionHost)psiElement) == null) {
            PsiElement psiElement2 = this.getSourcePsi();
            PsiElement psiElement3 = psiElement2 != null ? psiElement2.getParent() : null;
            if (!(psiElement3 instanceof PsiLanguageInjectionHost)) {
                psiElement3 = null;
            }
            psiLanguageInjectionHost = (PsiLanguageInjectionHost)psiElement3;
        }
        return psiLanguageInjectionHost;
    }

    @Nullable
    public final Pair<PsiLanguageInjectionHost, TextRange> getRangeAlignedToHost() {
        StringEntry entry = this;
        PsiElement psiElement = entry.getSourcePsi();
        if (psiElement == null) {
            return null;
        }
        PsiElement sourcePsi = psiElement;
        if (sourcePsi instanceof PsiLanguageInjectionHost) {
            return TuplesKt.to((Object)sourcePsi, (Object)entry.getRange());
        }
        PsiElement parent = sourcePsi.getParent();
        if (parent instanceof PsiLanguageInjectionHost) {
            return TuplesKt.to((Object)parent, (Object)entry.getRange().shiftRight(sourcePsi.getStartOffsetInParent()));
        }
        return null;
    }

    private StringEntry() {
    }

    public /* synthetic */ StringEntry(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000f\u001a\u00020\u0003H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0010"}, d2={"Lcom/intellij/psi/util/StringEntry$Known;", "Lcom/intellij/psi/util/StringEntry;", "value", "", "sourcePsi", "Lcom/intellij/psi/PsiElement;", "range", "Lcom/intellij/openapi/util/TextRange;", "(Ljava/lang/String;Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/util/TextRange;)V", "getRange", "()Lcom/intellij/openapi/util/TextRange;", "getSourcePsi", "()Lcom/intellij/psi/PsiElement;", "getValue", "()Ljava/lang/String;", "toString", "intellij.platform.lang"})
    public static final class Known
    extends StringEntry {
        @NotNull
        private final String value;
        @Nullable
        private final PsiElement sourcePsi;
        @NotNull
        private final TextRange range;

        @NotNull
        public String toString() {
            return "StringEntry.Known('" + this.value + "' at " + this.getRange() + " in " + this.getSourcePsi() + ')';
        }

        @NotNull
        public final String getValue() {
            return this.value;
        }

        @Override
        @Nullable
        public PsiElement getSourcePsi() {
            return this.sourcePsi;
        }

        @Override
        @NotNull
        public TextRange getRange() {
            return this.range;
        }

        public Known(@NotNull String value, @Nullable PsiElement sourcePsi, @NotNull TextRange range) {
            super(null);
            this.value = value;
            this.sourcePsi = sourcePsi;
            this.range = range;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\r"}, d2={"Lcom/intellij/psi/util/StringEntry$Unknown;", "Lcom/intellij/psi/util/StringEntry;", "sourcePsi", "Lcom/intellij/psi/PsiElement;", "range", "Lcom/intellij/openapi/util/TextRange;", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/util/TextRange;)V", "getRange", "()Lcom/intellij/openapi/util/TextRange;", "getSourcePsi", "()Lcom/intellij/psi/PsiElement;", "toString", "", "intellij.platform.lang"})
    public static final class Unknown
    extends StringEntry {
        @Nullable
        private final PsiElement sourcePsi;
        @NotNull
        private final TextRange range;

        @NotNull
        public String toString() {
            return "StringEntry.Unknown(at " + this.getRange() + " in " + this.getSourcePsi() + ')';
        }

        @Override
        @Nullable
        public PsiElement getSourcePsi() {
            return this.sourcePsi;
        }

        @Override
        @NotNull
        public TextRange getRange() {
            return this.range;
        }

        public Unknown(@Nullable PsiElement sourcePsi, @NotNull TextRange range) {
            super(null);
            this.sourcePsi = sourcePsi;
            this.range = range;
        }
    }
}

