/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.openapi.extensions.PluginId;
import com.intellij.psi.PsiElement;
import com.intellij.util.indexing.ID;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StubIndexKey<K, Psi extends PsiElement>
extends ID<K, Psi> {
    private StubIndexKey(@NonNls String name, @Nullable PluginId pluginId) {
        super(name, pluginId);
    }

    @NotNull
    public static synchronized <K, Psi extends PsiElement> StubIndexKey<K, Psi> createIndexKey(@NonNls @NotNull String name) {
        PluginId pluginId = StubIndexKey.getCallerPluginId();
        ID existing = StubIndexKey.findByName(name, true, pluginId);
        if (existing != null) {
            if (existing instanceof StubIndexKey) {
                return (StubIndexKey)existing;
            }
            throw new IllegalStateException("key with id " + name + " is already registered", existing.getRegistrationTrace());
        }
        return new StubIndexKey<K, Psi>(name, pluginId);
    }
}

