/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.openapi.application.ReadActionProcessor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.SearchRequestCollector;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import org.jetbrains.annotations.NotNull;

public class QuerySearchRequest {
    public final Query<PsiReference> query;
    public final SearchRequestCollector collector;
    public final Processor<? super PsiReference> processor;

    public QuerySearchRequest(@NotNull Query<PsiReference> query, final @NotNull SearchRequestCollector collector, boolean inReadAction, final @NotNull PairProcessor<? super PsiReference, ? super SearchRequestCollector> processor) {
        this.query = query;
        this.collector = collector;
        this.processor = inReadAction ? new ReadActionProcessor<PsiReference>(){

            @Override
            public boolean processInReadAction(PsiReference psiReference) {
                return processor.process((Object)psiReference, (Object)collector);
            }
        } : psiReference -> processor.process(psiReference, (Object)collector);
    }

    public boolean runQuery() {
        return this.query.forEach(this.processor);
    }

    public String toString() {
        return this.query + " -> " + this.collector;
    }
}

