/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.indexing.IndexingBundle;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ProjectAndLibrariesScope
extends GlobalSearchScope {
    protected final ProjectFileIndex myProjectFileIndex;
    private String myDisplayName;

    public ProjectAndLibrariesScope(@NotNull Project project) {
        super(project);
        this.myProjectFileIndex = ProjectRootManager.getInstance(project).getFileIndex();
    }

    @Deprecated
    public ProjectAndLibrariesScope(Project project, boolean searchOutsideRootModel) {
        this(project);
    }

    @Override
    public boolean contains(@NotNull VirtualFile file) {
        return this.myProjectFileIndex.isInContent(file) || this.myProjectFileIndex.isInLibrary(file);
    }

    @Override
    public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
        List<OrderEntry> entries1 = this.myProjectFileIndex.getOrderEntriesForFile(file1);
        List<OrderEntry> entries2 = this.myProjectFileIndex.getOrderEntriesForFile(file2);
        if (entries1.size() != entries2.size()) {
            return 0;
        }
        int res = 0;
        for (OrderEntry entry1 : entries1) {
            Module module = entry1.getOwnerModule();
            ModuleFileIndex moduleFileIndex = ModuleRootManager.getInstance(module).getFileIndex();
            OrderEntry entry2 = moduleFileIndex.getOrderEntryForFile(file2);
            if (entry2 == null) {
                return 0;
            }
            int aRes = entry2.compareTo(entry1);
            if (aRes == 0) {
                return 0;
            }
            if (res == 0) {
                res = aRes;
                continue;
            }
            if (res == aRes) continue;
            return 0;
        }
        return res;
    }

    @Override
    public boolean isSearchInModuleContent(@NotNull Module aModule) {
        return true;
    }

    @Override
    public boolean isSearchInLibraries() {
        return true;
    }

    @Override
    @NotNull
    public Collection<UnloadedModuleDescription> getUnloadedModulesBelongingToScope() {
        Project project = this.getProject();
        return project != null ? ModuleManager.getInstance(project).getUnloadedModuleDescriptions() : Collections.emptySet();
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return this.myDisplayName == null ? IndexingBundle.message("psi.search.scope.project.and.libraries", new Object[0]) : this.myDisplayName;
    }

    public void setDisplayName(@NotNull String displayName) {
        this.myDisplayName = displayName;
    }

    public String toString() {
        return this.getDisplayName();
    }
}

