/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.EverythingGlobalScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.SmartList;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IdFilter;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FilenameIndex {
    @ApiStatus.Internal
    @NonNls
    public static final ID<String, Void> NAME = ID.create("FilenameIndex");

    public static String @NotNull [] getAllFilenames(@Nullable Project project) {
        HashSet names = new HashSet();
        FilenameIndex.processAllFileNames((Processor<? super String>)((Processor)s -> {
            names.add(s);
            return true;
        }), project == null ? new EverythingGlobalScope() : GlobalSearchScope.allScope(project), null);
        return ArrayUtilRt.toStringArray(names);
    }

    public static void processAllFileNames(@NotNull Processor<? super String> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter filter) {
        FileBasedIndex.getInstance().processAllKeys(NAME, processor, scope, filter);
    }

    @NotNull
    public static Collection<VirtualFile> getVirtualFilesByName(Project project, @NotNull String name, @NotNull GlobalSearchScope scope) {
        return FilenameIndex.getVirtualFilesByName(name, scope, null);
    }

    @NotNull
    public static Collection<VirtualFile> getVirtualFilesByName(Project project, @NotNull String name, boolean caseSensitively, @NotNull GlobalSearchScope scope) {
        if (caseSensitively) {
            return FilenameIndex.getVirtualFilesByName(project, name, scope);
        }
        return FilenameIndex.getVirtualFilesByNameIgnoringCase(name, scope, null);
    }

    public static PsiFile @NotNull [] getFilesByName(@NotNull Project project, @NotNull String name, @NotNull GlobalSearchScope scope) {
        return (PsiFile[])FilenameIndex.getFilesByName(project, name, scope, false);
    }

    public static boolean processFilesByName(@NotNull String name, boolean directories, @NotNull Processor<? super PsiFileSystemItem> processor, @NotNull GlobalSearchScope scope, @NotNull Project project, @Nullable IdFilter idFilter) {
        return FilenameIndex.processFilesByName(name, directories, true, processor, scope, project, idFilter);
    }

    public static boolean processFilesByName(@NotNull String name, boolean directories, boolean caseSensitively, @NotNull Processor<? super PsiFileSystemItem> processor, @NotNull GlobalSearchScope scope, @NotNull Project project, @Nullable IdFilter idFilter) {
        Collection<VirtualFile> files = caseSensitively ? FilenameIndex.getVirtualFilesByName(name, scope, idFilter) : FilenameIndex.getVirtualFilesByNameIgnoringCase(name, scope, idFilter);
        if (files.isEmpty()) {
            return false;
        }
        PsiManager psiManager = PsiManager.getInstance(project);
        int processedFiles = 0;
        for (VirtualFile file : files) {
            PsiDirectory dir;
            if (!file.isValid()) continue;
            if (!directories && !file.isDirectory()) {
                PsiFile psiFile = psiManager.findFile(file);
                if (psiFile == null) continue;
                if (!processor.process((Object)psiFile)) {
                    return true;
                }
                ++processedFiles;
                continue;
            }
            if (!directories || !file.isDirectory() || (dir = psiManager.findDirectory(file)) == null) continue;
            if (!processor.process((Object)dir)) {
                return true;
            }
            ++processedFiles;
        }
        return processedFiles > 0;
    }

    @NotNull
    private static Set<VirtualFile> getVirtualFilesByNameIgnoringCase(@NotNull String name, @NotNull GlobalSearchScope scope, @Nullable IdFilter idFilter) {
        ObjectOpenHashSet keys = new ObjectOpenHashSet();
        FilenameIndex.processAllFileNames((Processor<? super String>)((Processor)arg_0 -> FilenameIndex.lambda$getVirtualFilesByNameIgnoringCase$1(name, (Set)keys, arg_0)), scope, idFilter);
        ObjectOpenHashSet files = new ObjectOpenHashSet();
        for (String each : keys) {
            files.addAll(FilenameIndex.getVirtualFilesByName(each, scope, idFilter));
        }
        return files;
    }

    public static PsiFileSystemItem @NotNull [] getFilesByName(@NotNull Project project, @NotNull String name, @NotNull GlobalSearchScope scope, boolean directories) {
        SmartList result = new SmartList();
        Processor processor = Processors.cancelableCollectProcessor(result);
        FilenameIndex.processFilesByName(name, directories, processor, scope, project, null);
        if (directories) {
            return (PsiFileSystemItem[])result.toArray((Object[])new PsiFileSystemItem[0]);
        }
        return (PsiFileSystemItem[])result.toArray((Object[])PsiFile.EMPTY_ARRAY);
    }

    @NotNull
    public static Collection<VirtualFile> getAllFilesByExt(@NotNull Project project, @NotNull String ext) {
        return FilenameIndex.getAllFilesByExt(project, ext, GlobalSearchScope.allScope(project));
    }

    @NotNull
    public static Collection<VirtualFile> getAllFilesByExt(@NotNull Project project, @NotNull String ext, @NotNull GlobalSearchScope searchScope) {
        int len = ext.length();
        if (len == 0) {
            return Collections.emptyList();
        }
        ext = "." + ext;
        ++len;
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>();
        for (String name : FilenameIndex.getAllFilenames(project)) {
            int length = name.length();
            if (length <= len || !name.substring(length - len).equalsIgnoreCase(ext)) continue;
            files.addAll(FilenameIndex.getVirtualFilesByName(project, name, searchScope));
        }
        return files;
    }

    @NotNull
    private static Collection<VirtualFile> getVirtualFilesByName(@NotNull String name, @NotNull GlobalSearchScope scope, IdFilter filter) {
        ObjectOpenHashSet files = new ObjectOpenHashSet();
        FileBasedIndex.getInstance().processValues(NAME, name, null, (arg_0, arg_1) -> FilenameIndex.lambda$getVirtualFilesByName$2((Set)files, arg_0, arg_1), scope, filter);
        return files;
    }

    private static /* synthetic */ boolean lambda$getVirtualFilesByName$2(Set files, VirtualFile file, Void value) {
        files.add(file);
        return true;
    }

    private static /* synthetic */ boolean lambda$getVirtualFilesByNameIgnoringCase$1(String name, Set keys, String value) {
        if (name.equalsIgnoreCase(value)) {
            keys.add(value);
        }
        return true;
    }
}

