/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference;

import com.intellij.lang.Language;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public abstract class ReferenceProvidersRegistry {
    public static final PsiReferenceProvider NULL_REFERENCE_PROVIDER = new PsiReferenceProvider(){

        @Override
        public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
            return PsiReference.EMPTY_ARRAY;
        }
    };

    public static ReferenceProvidersRegistry getInstance() {
        return ServiceManager.getService(ReferenceProvidersRegistry.class);
    }

    @NotNull
    public abstract PsiReferenceRegistrar getRegistrar(@NotNull Language var1);

    public static PsiReference @NotNull [] getReferencesFromProviders(@NotNull PsiElement context) {
        return ReferenceProvidersRegistry.getReferencesFromProviders(context, PsiReferenceService.Hints.NO_HINTS);
    }

    public static PsiReference @NotNull [] getReferencesFromProviders(@NotNull PsiElement context, @NotNull PsiReferenceService.Hints hints) {
        ProgressIndicatorProvider.checkCanceled();
        if (hints == PsiReferenceService.Hints.NO_HINTS) {
            return (PsiReference[])((PsiReference[])CachedValuesManager.getCachedValue(context, () -> CachedValueProvider.Result.create(ReferenceProvidersRegistry.getInstance().doGetReferencesFromProviders(context, PsiReferenceService.Hints.NO_HINTS), PsiModificationTracker.MODIFICATION_COUNT))).clone();
        }
        return ReferenceProvidersRegistry.getInstance().doGetReferencesFromProviders(context, hints);
    }

    @ApiStatus.Internal
    public abstract void unloadProvidersFor(@NotNull Language var1);

    protected abstract PsiReference @NotNull [] doGetReferencesFromProviders(@NotNull PsiElement var1, @NotNull PsiReferenceService.Hints var2);
}

