/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.arrangement.match;

import com.intellij.openapi.util.MultiValuesMap;
import com.intellij.psi.codeStyle.arrangement.ArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.match.ArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.match.ByModifierArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.match.ByNameArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.match.ByNamespaceArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.match.ByTextArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.match.ByTypeArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.match.CompositeArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementAtomMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementCompositeMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementMatchConditionVisitor;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementTokenType;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementTokens;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StdArrangementEntryMatcher
implements ArrangementEntryMatcher {
    @NotNull
    private final ArrangementMatchCondition myCondition;
    @NotNull
    private final ArrangementEntryMatcher myDelegate;

    public StdArrangementEntryMatcher(@NotNull ArrangementMatchCondition condition) {
        this(condition, new StdMatcherBuilderImpl());
    }

    public StdArrangementEntryMatcher(@NotNull ArrangementMatchCondition condition, @NotNull StdMatcherBuilder builder) {
        this.myCondition = condition;
        this.myDelegate = StdArrangementEntryMatcher.doBuildMatcher(condition, builder);
    }

    @NotNull
    public ArrangementMatchCondition getCondition() {
        return this.myCondition;
    }

    @Override
    public boolean isMatched(@NotNull ArrangementEntry entry) {
        return this.myDelegate.isMatched(entry);
    }

    public int hashCode() {
        return this.myCondition.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StdArrangementEntryMatcher matcher = (StdArrangementEntryMatcher)o;
        return this.myCondition.equals(matcher.myCondition);
    }

    public String toString() {
        return this.myCondition.toString();
    }

    @NotNull
    private static ArrangementEntryMatcher doBuildMatcher(@NotNull ArrangementMatchCondition condition, @NotNull StdMatcherBuilder builder) {
        MyVisitor visitor = new MyVisitor(builder);
        condition.invite(visitor);
        return visitor.getMatcher();
    }

    private static class MyVisitor
    implements ArrangementMatchConditionVisitor {
        @NotNull
        private final StdMatcherBuilder myMatcherBuilder;
        private boolean nestedComposite;

        private MyVisitor(@NotNull StdMatcherBuilder matcherBuilder) {
            this.myMatcherBuilder = matcherBuilder;
        }

        @Override
        public void visit(@NotNull ArrangementAtomMatchCondition condition) {
            this.myMatcherBuilder.onCondition(condition);
        }

        @Override
        public void visit(@NotNull ArrangementCompositeMatchCondition condition) {
            if (!this.nestedComposite) {
                this.nestedComposite = true;
                for (ArrangementMatchCondition c : condition.getOperands()) {
                    c.invite(this);
                }
            } else {
                this.myMatcherBuilder.addMatcher(StdArrangementEntryMatcher.doBuildMatcher(condition, this.myMatcherBuilder));
            }
        }

        @NotNull
        public ArrangementEntryMatcher getMatcher() {
            Collection<ArrangementEntryMatcher> matchers = this.myMatcherBuilder.buildMatchers();
            if (matchers.size() == 1) {
                return matchers.iterator().next();
            }
            CompositeArrangementEntryMatcher result = new CompositeArrangementEntryMatcher(new ArrangementEntryMatcher[0]);
            for (ArrangementEntryMatcher matcher : matchers) {
                result.addMatcher(matcher);
            }
            return result;
        }
    }

    public static class StdMatcherBuilderImpl
    implements StdMatcherBuilder {
        @NotNull
        private final List<ArrangementEntryMatcher> myMatchers = new ArrayList<ArrangementEntryMatcher>();
        @NotNull
        protected final MultiValuesMap<StdArrangementTokenType, ArrangementAtomMatchCondition> context = new MultiValuesMap();
        @Nullable
        private String myNamePattern;
        @Nullable
        private String myNamespacePattern;
        @Nullable
        private String myText;

        protected void addToContext(@NotNull StdArrangementSettingsToken token, @NotNull ArrangementAtomMatchCondition condition) {
            StdArrangementTokenType tokenType = token.getTokenType();
            this.context.put((Object)tokenType, (Object)condition);
        }

        @Override
        public void onCondition(@NotNull ArrangementAtomMatchCondition condition) {
            if (StdArrangementTokens.Regexp.NAME.equals(condition.getType())) {
                this.myNamePattern = condition.getValue().toString();
                return;
            }
            if (StdArrangementTokens.Regexp.XML_NAMESPACE.equals(condition.getType())) {
                this.myNamespacePattern = condition.getValue().toString();
            } else if (StdArrangementTokens.Regexp.TEXT.equals(condition.getType())) {
                this.myText = condition.getValue().toString();
            }
            Object v = condition.getValue();
            ArrangementSettingsToken type = condition.getType();
            if (type instanceof StdArrangementSettingsToken) {
                this.addToContext((StdArrangementSettingsToken)type, condition);
            }
        }

        @Override
        @Nullable
        public Collection<ArrangementEntryMatcher> buildMatchers() {
            Collection modifierTokens;
            ArrayList<ArrangementEntryMatcher> result = new ArrayList<ArrangementEntryMatcher>(this.myMatchers);
            Collection entryTokens = this.context.get((Object)StdArrangementTokenType.ENTRY_TYPE);
            if (entryTokens != null) {
                result.add(new ByTypeArrangementEntryMatcher(entryTokens));
            }
            if ((modifierTokens = this.context.get((Object)StdArrangementTokenType.MODIFIER)) != null) {
                result.add(new ByModifierArrangementEntryMatcher(modifierTokens));
            }
            if (this.myNamePattern != null) {
                result.add(new ByNameArrangementEntryMatcher(this.myNamePattern));
            }
            if (this.myNamespacePattern != null) {
                result.add(new ByNamespaceArrangementEntryMatcher(this.myNamespacePattern));
            }
            if (this.myText != null) {
                result.add(new ByTextArrangementEntryMatcher(this.myText));
            }
            return result;
        }

        @Override
        public void addMatcher(@NotNull ArrangementEntryMatcher matcher) {
            this.myMatchers.add(matcher);
        }
    }

    public static interface StdMatcherBuilder {
        public void onCondition(@NotNull ArrangementAtomMatchCondition var1);

        @Nullable
        public Collection<ArrangementEntryMatcher> buildMatchers();

        public void addMatcher(@NotNull ArrangementEntryMatcher var1);
    }
}

