/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.model.Symbol;
import com.intellij.model.SymbolResolveResult;
import com.intellij.model.psi.PsiSymbolReference;
import com.intellij.model.psi.PsiSymbolService;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PsiReference
extends PsiSymbolReference {
    public static final PsiReference[] EMPTY_ARRAY = new PsiReference[0];
    public static final ArrayFactory<PsiReference> ARRAY_FACTORY = count -> count == 0 ? EMPTY_ARRAY : new PsiReference[count];

    @Override
    @NotNull
    public PsiElement getElement();

    @Override
    @NotNull
    public TextRange getRangeInElement();

    @Nullable
    public PsiElement resolve();

    @NotNull
    public String getCanonicalText();

    public PsiElement handleElementRename(@NotNull String var1) throws IncorrectOperationException;

    public PsiElement bindToElement(@NotNull PsiElement var1) throws IncorrectOperationException;

    public boolean isReferenceTo(@NotNull PsiElement var1);

    default public Object @NotNull [] getVariants() {
        return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
    }

    public boolean isSoft();

    @Override
    @ApiStatus.Experimental
    @NotNull
    default public Collection<? extends SymbolResolveResult> resolveReference() {
        PsiElement resolved = this.resolve();
        if (resolved == null) {
            return Collections.emptyList();
        }
        Symbol symbol = PsiSymbolService.getInstance().asSymbol(resolved);
        return Collections.singletonList(SymbolResolveResult.fromSymbol(symbol));
    }

    @Override
    @ApiStatus.Experimental
    default public boolean resolvesTo(@NotNull Symbol target) {
        PsiElement psi = PsiSymbolService.getInstance().extractElementFromSymbol(target);
        return psi == null ? PsiSymbolReference.super.resolvesTo(target) : this.isReferenceTo(psi);
    }
}

