/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.ExceptionWithAttachments;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.JBIterable;
import java.lang.ref.SoftReference;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiInvalidElementAccessException
extends RuntimeException
implements ExceptionWithAttachments {
    private static final Key<Object> INVALIDATION_TRACE = Key.create((String)"INVALIDATION_TRACE");
    private static final Key<Boolean> REPORTING_EXCEPTION = Key.create((String)"REPORTING_EXCEPTION");
    private final SoftReference<PsiElement> myElementReference;
    private final Attachment[] myDiagnostic;
    private final String myMessage;

    public PsiInvalidElementAccessException(@Nullable PsiElement element) {
        this(element, null, null);
    }

    public PsiInvalidElementAccessException(@Nullable PsiElement element, @Nullable String message) {
        this(element, message, null);
    }

    public PsiInvalidElementAccessException(@Nullable PsiElement element, @Nullable Throwable cause) {
        this(element, null, cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PsiInvalidElementAccessException(@Nullable PsiElement element, @Nullable String message, @Nullable Throwable cause) {
        super(null, cause);
        this.myElementReference = new SoftReference<PsiElement>(element);
        if (element == null) {
            this.myMessage = message;
            this.myDiagnostic = Attachment.EMPTY_ARRAY;
        } else if (element == PsiUtilCore.NULL_PSI_ELEMENT) {
            this.myMessage = "NULL_PSI_ELEMENT ;" + message;
            this.myDiagnostic = Attachment.EMPTY_ARRAY;
        } else {
            boolean recursiveInvocation = Boolean.TRUE.equals(element.getUserData(REPORTING_EXCEPTION));
            element.putUserData(REPORTING_EXCEPTION, Boolean.TRUE);
            try {
                Object trace = recursiveInvocation ? null : PsiInvalidElementAccessException.getPsiInvalidationTrace(element);
                this.myMessage = PsiInvalidElementAccessException.getMessageWithReason(element, message, recursiveInvocation, trace);
                this.myDiagnostic = PsiInvalidElementAccessException.createAttachments(trace);
            }
            finally {
                element.putUserData(REPORTING_EXCEPTION, null);
            }
        }
    }

    private PsiInvalidElementAccessException(@NotNull ASTNode node, @Nullable String message) {
        this.myElementReference = new SoftReference<Object>(null);
        IElementType elementType = node.getElementType();
        this.myMessage = "Element " + node.getClass() + " of type " + elementType + " (" + elementType.getClass() + ")" + (message == null ? "" : "; " + message);
        this.myDiagnostic = PsiInvalidElementAccessException.createAttachments(PsiInvalidElementAccessException.findInvalidationTrace(node));
    }

    public static PsiInvalidElementAccessException createByNode(@NotNull ASTNode node, @Nullable String message) {
        return new PsiInvalidElementAccessException(node, message);
    }

    private static Attachment @NotNull [] createAttachments(@Nullable Object trace) {
        Attachment[] attachmentArray;
        if (trace == null) {
            attachmentArray = Attachment.EMPTY_ARRAY;
        } else {
            Attachment[] attachmentArray2 = new Attachment[1];
            attachmentArray = attachmentArray2;
            attachmentArray2[0] = trace instanceof Throwable ? new Attachment("invalidation", (Throwable)trace) : new Attachment("diagnostic.txt", trace.toString());
        }
        return attachmentArray;
    }

    @Nullable
    private static Object getPsiInvalidationTrace(@NotNull PsiElement element) {
        Object trace = PsiInvalidElementAccessException.getInvalidationTrace(element);
        if (trace != null) {
            return trace;
        }
        if (element instanceof PsiFile) {
            return PsiInvalidElementAccessException.getInvalidationTrace(((PsiFile)element).getOriginalFile());
        }
        return PsiInvalidElementAccessException.findInvalidationTrace(element.getNode());
    }

    private static String getMessageWithReason(@NotNull PsiElement element, @Nullable String message, boolean recursiveInvocation, @Nullable Object trace) {
        String reason = "Element: " + element.getClass();
        if (!recursiveInvocation) {
            try {
                reason = reason + " #" + PsiInvalidElementAccessException.getLanguage(element).getID() + " ";
            }
            catch (PsiInvalidElementAccessException psiInvalidElementAccessException) {
                // empty catch block
            }
            String traceText = !PsiInvalidElementAccessException.isTrackingInvalidation() ? "disabled" : (trace != null ? "see attachment" : "no info");
            try {
                reason = reason + " because: " + PsiInvalidElementAccessException.findOutInvalidationReason(element);
            }
            catch (PsiInvalidElementAccessException psiInvalidElementAccessException) {
                // empty catch block
            }
            reason = reason + "\ninvalidated at: " + traceText;
        }
        return reason + (message == null ? "" : "; " + message);
    }

    @NotNull
    private static Language getLanguage(@NotNull PsiElement element) {
        return element instanceof ASTNode ? ((ASTNode)((Object)element)).getElementType().getLanguage() : element.getLanguage();
    }

    @Override
    public String getMessage() {
        return this.myMessage;
    }

    public Attachment @NotNull [] getAttachments() {
        return this.myDiagnostic;
    }

    public static Object findInvalidationTrace(@Nullable ASTNode element) {
        while (element != null) {
            Object trace = element.getUserData(INVALIDATION_TRACE);
            if (trace != null) {
                return trace;
            }
            ASTNode parent = element.getTreeParent();
            if (parent == null && element instanceof FileASTNode) {
                PsiElement psi = element.getPsi();
                Object object = trace = psi == null ? null : psi.getUserData(INVALIDATION_TRACE);
                if (trace != null) {
                    return trace;
                }
            }
            element = parent;
        }
        return null;
    }

    @NonNls
    @NotNull
    public static String findOutInvalidationReason(@NotNull PsiElement root) {
        PsiElement context;
        PsiElement element;
        if (root == PsiUtilCore.NULL_PSI_ELEMENT) {
            return "NULL_PSI_ELEMENT";
        }
        PsiElement lastParent = root;
        PsiElement psiElement = element = root instanceof PsiFile ? root : root.getParent();
        if (element == null) {
            String m = "parent is null";
            if (root instanceof StubBasedPsiElement) {
                for (Object stub = ((StubBasedPsiElement)root).getStub(); stub != null; stub = stub.getParentStub()) {
                    m = m + "\n  each stub=" + stub;
                    if (!(stub instanceof PsiFileStub)) continue;
                    m = m + "; fileStub.psi=" + stub.getPsi() + "; reason=" + ((PsiFileStub)stub).getInvalidationReason();
                }
            }
            return m;
        }
        String hierarchy = "";
        while (element != null && !(element instanceof PsiFile)) {
            hierarchy = hierarchy + (hierarchy.isEmpty() ? "," : "") + element.getClass();
            lastParent = element;
            element = element.getParent();
        }
        PsiFile file = (PsiFile)element;
        if (file == null) {
            PsiElement context2 = lastParent.getContext();
            return "containing file is null; hierarchy=" + hierarchy + ", context=" + context2 + ", contextFile=" + JBIterable.generate((Object)context2, PsiElement::getParent).find(e -> e instanceof PsiFile);
        }
        FileViewProvider provider = file.getViewProvider();
        VirtualFile vFile = provider.getVirtualFile();
        if (!vFile.isValid()) {
            return vFile + " is invalid";
        }
        if (!provider.isPhysical() && (context = file.getContext()) != null && !context.isValid()) {
            return "invalid context: " + PsiInvalidElementAccessException.findOutInvalidationReason(context);
        }
        PsiFile original = file.getOriginalFile();
        if (original != file && !original.isValid()) {
            return "invalid original: " + PsiInvalidElementAccessException.findOutInvalidationReason(original);
        }
        PsiManager manager = file.getManager();
        if (manager.getProject().isDisposed()) {
            return "project is disposed: " + manager.getProject();
        }
        Language language = file.getLanguage();
        if (language != provider.getBaseLanguage()) {
            return "File language:" + (Object)((Object)language) + " != Provider base language:" + (Object)((Object)provider.getBaseLanguage());
        }
        FileViewProvider p = manager.findViewProvider(vFile);
        if (provider != p) {
            return "different providers: " + provider + "(" + PsiInvalidElementAccessException.id(provider) + "); " + p + "(" + PsiInvalidElementAccessException.id(p) + ")";
        }
        if (!provider.isPhysical()) {
            return "non-physical provider: " + provider;
        }
        return "psi is outdated";
    }

    private static String id(FileViewProvider provider) {
        return Integer.toHexString(System.identityHashCode(provider));
    }

    public static void setInvalidationTrace(@NotNull UserDataHolder element, Object trace) {
        element.putUserData(INVALIDATION_TRACE, trace);
    }

    public static Object getInvalidationTrace(@NotNull UserDataHolder element) {
        return element.getUserData(INVALIDATION_TRACE);
    }

    public static boolean isTrackingInvalidation() {
        return Registry.is((String)"psi.track.invalidation");
    }

    @Nullable
    public PsiElement getPsiElement() {
        return this.myElementReference.get();
    }
}

