/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.ExpirableRunnable;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PassThroughIdeFocusManager
extends IdeFocusManager {
    private static final PassThroughIdeFocusManager ourInstance = new PassThroughIdeFocusManager();

    public static PassThroughIdeFocusManager getInstance() {
        return ourInstance;
    }

    @Override
    @NotNull
    public ActionCallback requestFocus(@NotNull Component c, boolean forced) {
        c.requestFocus();
        return ActionCallback.DONE;
    }

    @Override
    public JComponent getFocusTargetFor(@NotNull JComponent component) {
        return component;
    }

    @Override
    public void doWhenFocusSettlesDown(@NotNull Runnable runnable) {
        runnable.run();
    }

    @Override
    public void doWhenFocusSettlesDown(@NotNull Runnable runnable, @NotNull ModalityState modality) {
        runnable.run();
    }

    @Override
    public void doWhenFocusSettlesDown(@NotNull ExpirableRunnable runnable) {
        if (!runnable.isExpired()) {
            runnable.run();
        }
    }

    @Override
    public Component getFocusedDescendantFor(@NotNull Component component) {
        Component focused = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (focused == null) {
            return null;
        }
        if (focused == component || SwingUtilities.isDescendingFrom(focused, component)) {
            return focused;
        }
        return null;
    }

    @Override
    public boolean isFocusTransferEnabled() {
        return true;
    }

    @Override
    public void setTypeaheadEnabled(boolean enabled) {
    }

    @Override
    public Component getFocusOwner() {
        return KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
    }

    @Override
    public void runOnOwnContext(@NotNull DataContext context, @NotNull Runnable runnable) {
        runnable.run();
    }

    @Override
    public Component getLastFocusedFor(@Nullable Window frame) {
        return null;
    }

    @Override
    public IdeFrame getLastFocusedFrame() {
        return null;
    }

    @Override
    @Nullable
    public Window getLastFocusedIdeWindow() {
        return null;
    }

    @Override
    public void toFront(JComponent c) {
    }
}

