/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.util.containers.ContainerUtil;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileAttribute {
    private static final Set<String> ourRegisteredIds = ContainerUtil.newConcurrentSet();
    private static final int UNDEFINED_VERSION = -1;
    private final String myId;
    private final int myVersion;
    private final boolean myFixedSize;

    public FileAttribute(@NonNls @NotNull String id) {
        this(id, -1, false);
    }

    public FileAttribute(@NonNls @NotNull String id, int version, boolean fixedSize) {
        this(version, fixedSize, id);
        boolean added = ourRegisteredIds.add(id);
        assert (added) : "Attribute id='" + id + "' is not unique";
    }

    private FileAttribute(int version, boolean fixedSize, @NotNull String id) {
        this.myId = id;
        this.myVersion = version;
        this.myFixedSize = fixedSize;
    }

    @Nullable
    public DataInputStream readAttribute(@NotNull VirtualFile file) {
        return ManagingFS.getInstance().readAttribute(file, this);
    }

    @NotNull
    public DataOutputStream writeAttribute(@NotNull VirtualFile file) {
        return ManagingFS.getInstance().writeAttribute(file, this);
    }

    public byte @Nullable [] readAttributeBytes(VirtualFile file) throws IOException {
        try (DataInputStream stream = this.readAttribute(file);){
            if (stream == null) {
                byte[] byArray = null;
                return byArray;
            }
            int len = stream.readInt();
            byte[] byArray = FileUtil.loadBytes((InputStream)stream, (int)len);
            return byArray;
        }
    }

    public void writeAttributeBytes(VirtualFile file, byte @NotNull [] bytes) throws IOException {
        this.writeAttributeBytes(file, bytes, 0, bytes.length);
    }

    public void writeAttributeBytes(VirtualFile file, byte[] bytes, int offset, int len) throws IOException {
        try (DataOutputStream stream = this.writeAttribute(file);){
            stream.writeInt(len);
            stream.write(bytes, offset, len);
        }
    }

    @NotNull
    public String getId() {
        return this.myId;
    }

    public boolean isFixedSize() {
        return this.myFixedSize;
    }

    @NotNull
    public FileAttribute newVersion(int newVersion) {
        return new FileAttribute(newVersion, this.myFixedSize, this.myId);
    }

    public int getVersion() {
        return this.myVersion;
    }

    public boolean isVersioned() {
        return this.myVersion != -1;
    }
}

