/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CachedSingletonsRegistry;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManagerListener;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.util.messages.Topic;
import java.nio.file.Path;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VirtualFileManager
implements ModificationTracker {
    public static final Topic<BulkFileListener> VFS_CHANGES = new Topic(BulkFileListener.class, Topic.BroadcastDirection.TO_DIRECT_CHILDREN);
    @NotNull
    public static final ModificationTracker VFS_STRUCTURE_MODIFICATIONS = () -> VirtualFileManager.getInstance().getStructureModificationCount();
    private static VirtualFileManager ourInstance = CachedSingletonsRegistry.markCachedField(VirtualFileManager.class);

    @NotNull
    public static VirtualFileManager getInstance() {
        VirtualFileManager result = ourInstance;
        if (result == null) {
            ourInstance = result = (VirtualFileManager)ApplicationManager.getApplication().getService(VirtualFileManager.class);
        }
        return result;
    }

    public abstract VirtualFileSystem getFileSystem(String var1);

    public abstract long syncRefresh();

    public abstract long asyncRefresh(@Nullable Runnable var1);

    public abstract void refreshWithoutFileWatcher(boolean var1);

    @Nullable
    public VirtualFile findFileByUrl(@NonNls @NotNull String url) {
        return null;
    }

    @Nullable
    public VirtualFile findFileByNioPath(@NotNull Path path2) {
        return null;
    }

    @Nullable
    public VirtualFile refreshAndFindFileByUrl(@NotNull String url) {
        return null;
    }

    @Nullable
    public VirtualFile refreshAndFindFileByNioPath(@NotNull Path path2) {
        return null;
    }

    @Deprecated
    public abstract void addVirtualFileListener(@NotNull VirtualFileListener var1);

    @Deprecated
    public abstract void addVirtualFileListener(@NotNull VirtualFileListener var1, @NotNull Disposable var2);

    @Deprecated
    public abstract void removeVirtualFileListener(@NotNull VirtualFileListener var1);

    public abstract void addAsyncFileListener(@NotNull AsyncFileListener var1, @NotNull Disposable var2);

    @NotNull
    public static String constructUrl(@NotNull String protocol, @NotNull String path2) {
        return protocol + "://" + path2;
    }

    @Nullable
    public static String extractProtocol(@NotNull String url) {
        int index = url.indexOf("://");
        if (index < 0) {
            return null;
        }
        return url.substring(0, index);
    }

    @NotNull
    public static String extractPath(@NotNull String url) {
        int index = url.indexOf("://");
        return index >= 0 ? url.substring(index + "://".length()) : url;
    }

    public abstract void addVirtualFileManagerListener(@NotNull VirtualFileManagerListener var1);

    public abstract void addVirtualFileManagerListener(@NotNull VirtualFileManagerListener var1, @NotNull Disposable var2);

    public abstract void removeVirtualFileManagerListener(@NotNull VirtualFileManagerListener var1);

    public abstract void notifyPropertyChanged(@NotNull VirtualFile var1, @VirtualFile.PropName @NotNull String var2, Object var3, Object var4);

    @Override
    public abstract long getModificationCount();

    public abstract long getStructureModificationCount();

    public VirtualFile findFileById(int id) {
        return null;
    }

    @ApiStatus.Internal
    public abstract int storeName(@NotNull String var1);

    @ApiStatus.Internal
    @NotNull
    public abstract CharSequence getVFileName(int var1);
}

