/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsConsoleLine {
    private final List<Pair<String, ConsoleViewContentType>> myChunks;

    private VcsConsoleLine(@NotNull List<Pair<String, ConsoleViewContentType>> chunks) {
        this.myChunks = chunks;
    }

    public void print(@NotNull ConsoleView console) {
        ConsoleViewContentType lastType = ConsoleViewContentType.NORMAL_OUTPUT;
        for (Pair<String, ConsoleViewContentType> chunk : this.myChunks) {
            console.print((String)chunk.first, (ConsoleViewContentType)chunk.second);
            lastType = (ConsoleViewContentType)chunk.second;
        }
        console.print("\n", lastType);
    }

    @Nullable
    public static VcsConsoleLine create(@Nullable String message, @NotNull ConsoleViewContentType contentType) {
        return VcsConsoleLine.create(Collections.singletonList(Pair.create((Object)message, (Object)contentType)));
    }

    @Nullable
    public static VcsConsoleLine create(@NotNull List<Pair<String, ConsoleViewContentType>> lineChunks) {
        List chunks = ContainerUtil.filter(lineChunks, it -> !StringUtil.isEmptyOrSpaces((String)((String)it.first)));
        if (chunks.isEmpty()) {
            return null;
        }
        return new VcsConsoleLine(chunks);
    }
}

