/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.util.PathUtil;
import java.io.File;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalFilePath
implements FilePath {
    @NotNull
    private final String myPath;
    private final boolean myIsDirectory;
    private VirtualFile myCachedFile;

    public LocalFilePath(@NotNull String path2, boolean isDirectory) {
        this.myPath = FileUtil.toCanonicalPath((String)path2);
        this.myIsDirectory = isDirectory;
    }

    private LocalFilePath(@NotNull String path2, boolean isDirectory, @Nullable Void privateConstructorMarker) {
        this.myPath = path2;
        this.myIsDirectory = isDirectory;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocalFilePath path2 = (LocalFilePath)o;
        if (this.myIsDirectory != path2.myIsDirectory) {
            return false;
        }
        return FileUtil.PATH_HASHING_STRATEGY.equals((Object)this.myPath, (Object)path2.myPath);
    }

    public int hashCode() {
        int result = FileUtil.PATH_HASHING_STRATEGY.computeHashCode((Object)this.myPath);
        result = 31 * result + (this.myIsDirectory ? 1 : 0);
        return result;
    }

    @Override
    public void refresh() {
    }

    @Override
    public void hardRefresh() {
        LocalFileSystem.getInstance().refreshAndFindFileByPath(this.myPath);
    }

    @Override
    @NotNull
    public String getPath() {
        return this.myPath;
    }

    @Override
    public boolean isDirectory() {
        return this.myIsDirectory;
    }

    @Override
    public boolean isUnder(@NotNull FilePath parent, boolean strict) {
        return FileUtil.startsWith((String)this.getPath(), (String)parent.getPath(), (boolean)SystemInfo.isFileSystemCaseSensitive, (boolean)strict);
    }

    @Override
    @Nullable
    public FilePath getParentPath() {
        String parent = PathUtil.getParentPath(this.myPath);
        return parent.isEmpty() ? null : new LocalFilePath(parent, true, null);
    }

    @Override
    @Nullable
    public VirtualFile getVirtualFile() {
        VirtualFile cachedFile = this.myCachedFile;
        if (cachedFile == null || !cachedFile.isValid() || !FileUtil.PATH_HASHING_STRATEGY.equals((Object)cachedFile.getPath(), (Object)this.myPath)) {
            this.myCachedFile = cachedFile = LocalFileSystem.getInstance().findFileByPath(this.myPath);
        }
        return cachedFile;
    }

    @Override
    @Nullable
    public VirtualFile getVirtualFileParent() {
        FilePath parent = this.getParentPath();
        return parent != null ? parent.getVirtualFile() : null;
    }

    @Override
    @NotNull
    public File getIOFile() {
        return new File(this.myPath);
    }

    @Override
    @NotNull
    public String getName() {
        return PathUtil.getFileName(this.myPath);
    }

    @Override
    @NotNull
    public String getPresentableUrl() {
        return FileUtil.toSystemDependentName((String)this.myPath);
    }

    @Override
    @Nullable
    public Document getDocument() {
        VirtualFile file = this.getVirtualFile();
        if (file == null || file.getFileType().isBinary()) {
            return null;
        }
        return FileDocumentManager.getInstance().getDocument(file);
    }

    @Override
    @NotNull
    public Charset getCharset() {
        return this.getCharset(null);
    }

    @Override
    @NotNull
    public Charset getCharset(@Nullable Project project) {
        VirtualFile file = this.getVirtualFile();
        String path2 = this.myPath;
        while (!(file != null && file.isValid() || path2.isEmpty())) {
            path2 = PathUtil.getParentPath(path2);
            file = LocalFileSystem.getInstance().findFileByPath(path2);
        }
        if (file != null) {
            return file.getCharset();
        }
        EncodingManager e = project == null ? EncodingManager.getInstance() : EncodingProjectManager.getInstance(project);
        return e.getDefaultCharset();
    }

    @Override
    @NotNull
    public FileType getFileType() {
        VirtualFile file = this.getVirtualFile();
        FileTypeManager manager = FileTypeManager.getInstance();
        return file != null ? manager.getFileTypeByFile(file) : manager.getFileTypeByFileName(this.getName());
    }

    @NonNls
    public String toString() {
        return this.myPath + (this.myIsDirectory ? "/" : "");
    }

    @Override
    public boolean isNonLocal() {
        return false;
    }
}

