/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusListener;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;

public abstract class FileStatusManager {
    public static FileStatusManager getInstance(@NotNull Project project) {
        return (FileStatusManager)project.getService(FileStatusManager.class);
    }

    public abstract FileStatus getStatus(@NotNull VirtualFile var1);

    public abstract void fileStatusesChanged();

    public abstract void fileStatusChanged(VirtualFile var1);

    @Deprecated
    public abstract void addFileStatusListener(@NotNull FileStatusListener var1);

    public abstract void addFileStatusListener(@NotNull FileStatusListener var1, @NotNull Disposable var2);

    public abstract void removeFileStatusListener(@NotNull FileStatusListener var1);

    public abstract Color getNotChangedDirectoryColor(@NotNull VirtualFile var1);

    @NotNull
    public FileStatus getRecursiveStatus(@NotNull VirtualFile file) {
        FileStatus status = this.getStatus(file);
        return status != null ? status : FileStatus.NOT_CHANGED;
    }

    public abstract void refreshFileStatusFromDocument(VirtualFile var1, Document var2);
}

