/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.util.text.DateFormatUtil;
import java.util.Comparator;
import java.util.Date;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ChangeListColumn<T extends ChangeList> {
    public static final ChangeListColumn<CommittedChangeList> DATE = new ChangeListColumn<CommittedChangeList>(){

        @Override
        @NotNull
        public String getTitle() {
            return VcsBundle.message("column.name.revision.list.date", new Object[0]);
        }

        @Override
        @NotNull
        public Object getValue(@NotNull CommittedChangeList changeList) {
            return DateFormatUtil.formatPrettyDateTime((Date)changeList.getCommitDate());
        }

        @Override
        @NotNull
        public Comparator<CommittedChangeList> getComparator() {
            return Comparator.comparing(CommittedChangeList::getCommitDate);
        }
    };
    public static final ChangeListColumn<CommittedChangeList> NAME = new ChangeListColumn<CommittedChangeList>(){

        @Override
        @NotNull
        public String getTitle() {
            return VcsBundle.message("column.name.revision.list.committer", new Object[0]);
        }

        @Override
        public Object getValue(@NotNull CommittedChangeList changeList) {
            return changeList.getCommitterName();
        }

        @Override
        @NotNull
        public Comparator<CommittedChangeList> getComparator() {
            return (changeList1, changeList2) -> Comparing.compare((Comparable)((Object)changeList1.getCommitterName()), (Comparable)((Object)changeList2.getCommitterName()));
        }
    };
    public static final ChangeListColumn<CommittedChangeList> NUMBER = new ChangeListNumberColumn(VcsBundle.message("column.name.revision.list.number", new Object[0]));
    public static final ChangeListColumn<CommittedChangeList> DESCRIPTION = new ChangeListColumn<CommittedChangeList>(){

        @Override
        @NotNull
        public String getTitle() {
            return VcsBundle.message("column.name.revision.list.description", new Object[0]);
        }

        @Override
        @NotNull
        public Object getValue(@NotNull CommittedChangeList changeList) {
            return changeList.getName();
        }

        @Override
        @NotNull
        public Comparator<CommittedChangeList> getComparator() {
            return Comparator.comparing(list -> list.getName(), String::compareToIgnoreCase);
        }
    };

    public abstract String getTitle();

    public abstract Object getValue(T var1);

    @Nullable
    public Comparator<T> getComparator() {
        return null;
    }

    public static boolean isCustom(@NotNull ChangeListColumn column) {
        return column != DATE && column != DESCRIPTION && column != NAME && !(column instanceof ChangeListNumberColumn);
    }

    public static class ChangeListNumberColumn
    extends ChangeListColumn<CommittedChangeList> {
        private final String myTitle;

        public ChangeListNumberColumn(String title) {
            this.myTitle = title;
        }

        @Override
        public String getTitle() {
            return this.myTitle;
        }

        @Override
        @NotNull
        public Object getValue(@NotNull CommittedChangeList changeList) {
            return changeList.getNumber();
        }

        @Override
        @NotNull
        public Comparator<CommittedChangeList> getComparator() {
            return Comparator.comparingLong(CommittedChangeList::getNumber);
        }
    }
}

