/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.process;

import com.intellij.util.concurrency.AppExecutorUtil;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public final class ProcessCloseUtil {
    private static final long ourSynchronousWaitTimeout = 1000L;
    private static final long ourAsynchronousWaitTimeout = 30000L;

    public static void close(@NotNull Process process) {
        try {
            if (process.waitFor(1000L, TimeUnit.MILLISECONDS)) {
                ProcessCloseUtil.closeStreams(process);
                return;
            }
        }
        catch (InterruptedException e) {
            ProcessCloseUtil.closeStreams(process);
            throw new RuntimeException(e);
        }
        process.destroy();
        AppExecutorUtil.getAppScheduledExecutorService().schedule(() -> {
            try {
                if (process.isAlive()) {
                    process.destroyForcibly();
                }
            }
            finally {
                ProcessCloseUtil.closeStreams(process);
            }
        }, 30000L, TimeUnit.MILLISECONDS);
    }

    private static void closeStreams(@NotNull Process process) {
        try {
            process.getOutputStream().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            process.getInputStream().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            process.getErrorStream().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

