/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.configurationStore.XmlSerializer;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MasterDetailsState;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.XCollection;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="masterDetails", storages={@Storage(value="$PRODUCT_WORKSPACE_FILE$"), @Storage(value="$WORKSPACE_FILE$", deprecated=true)})
public final class MasterDetailsStateService
implements PersistentStateComponent<States> {
    private final Map<String, ComponentState> myStates = new HashMap<String, ComponentState>();

    public static MasterDetailsStateService getInstance(@NotNull Project project) {
        return ServiceManager.getService(project, MasterDetailsStateService.class);
    }

    @Nullable
    public MasterDetailsState getComponentState(@NotNull @NonNls String key, Class<? extends MasterDetailsState> stateClass) {
        ComponentState state = this.myStates.get(key);
        if (state == null) {
            return null;
        }
        Element settings = state.mySettings;
        return settings == null ? null : XmlSerializer.deserialize(settings, stateClass);
    }

    public void setComponentState(@NotNull @NonNls String key, @NotNull MasterDetailsState state) {
        Element element = XmlSerializer.serialize(state);
        ComponentState componentState = new ComponentState();
        componentState.myKey = key;
        componentState.mySettings = element;
        this.myStates.put(key, componentState);
    }

    @Override
    public States getState() {
        States states = new States();
        states.myStates.addAll(this.myStates.values());
        states.getStates().sort(Comparator.comparing(o -> o.myKey));
        return states;
    }

    @Override
    public void loadState(@NotNull States states) {
        this.myStates.clear();
        for (ComponentState state : states.getStates()) {
            this.myStates.put(state.myKey, state);
        }
    }

    public static final class States {
        private List<ComponentState> myStates = new ArrayList<ComponentState>();

        @XCollection(style=XCollection.Style.v2)
        public List<ComponentState> getStates() {
            return this.myStates;
        }

        public void setStates(List<ComponentState> states) {
            this.myStates = states;
        }
    }

    @Tag(value="state")
    public static final class ComponentState {
        @Attribute(value="key")
        public String myKey;
        @Tag(value="settings")
        public Element mySettings;
    }
}

