/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.ComboBoxWithWidePopup;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.ui.components.fields.ExtendableTextField;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.CellEditor;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JRootPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.table.TableCellEditor;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComboBox<E>
extends ComboBoxWithWidePopup<E>
implements AWTEventListener {
    public static final String TABLE_CELL_EDITOR_PROPERTY = "tableCellEditor";
    private int myMinimumAndPreferredWidth;
    protected boolean myPaintingNow;

    public ComboBox() {
        this.init(-1);
    }

    public ComboBox(int width) {
        this.init(width);
    }

    public ComboBox(@NotNull ComboBoxModel<E> model) {
        super(model);
        this.init(-1);
    }

    public ComboBox(E @NotNull [] items) {
        super(items);
        this.init(-1);
    }

    public ComboBox(E @NotNull [] items, int width) {
        super(items);
        this.init(width);
    }

    public ComboBox(@NotNull ComboBoxModel<E> model, int width) {
        super(model);
        this.init(width);
    }

    private void init(int width) {
        this.myMinimumAndPreferredWidth = width;
        this.registerCancelOnEscape();
        ComboBox.installComboBoxCopyAction(this);
    }

    private static void installComboBoxCopyAction(@NotNull JComboBox comboBox) {
        Component editorComponent;
        ComboBoxEditor editor = comboBox.getEditor();
        Component component = editorComponent = editor != null ? editor.getEditorComponent() : null;
        if (!(editorComponent instanceof JTextComponent)) {
            return;
        }
        InputMap inputMap = ((JTextComponent)editorComponent).getInputMap();
        for (KeyStroke keyStroke : inputMap.allKeys()) {
            if (!"copy-to-clipboard".equals(inputMap.get(keyStroke))) continue;
            comboBox.getInputMap().put(keyStroke, "copy-to-clipboard");
        }
        comboBox.getActionMap().put("copy-to-clipboard", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String str;
                Component component;
                if (!(e.getSource() instanceof JComboBox)) {
                    return;
                }
                JComboBox comboBox = (JComboBox)e.getSource();
                Object selectedItem = comboBox.getSelectedItem();
                String text = selectedItem instanceof String ? (String)selectedItem : ((component = comboBox.getRenderer().getListCellRendererComponent(new JList(), selectedItem, 0, false, false)) instanceof JLabel ? ((JLabel)component).getText() : (component != null ? ((str = component.toString()) == null || str.startsWith(component.getClass().getName() + "[") ? null : str) : null));
                if (text != null) {
                    JTextField textField = new JTextField(text);
                    textField.selectAll();
                    textField.copy();
                }
            }
        });
    }

    public static void registerTableCellEditor(@NotNull JComboBox comboBox, @NotNull TableCellEditor cellEditor) {
        comboBox.putClientProperty(TABLE_CELL_EDITOR_PROPERTY, cellEditor);
        comboBox.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
    }

    public void registerTableCellEditor(@NotNull TableCellEditor cellEditor) {
        ComboBox.registerTableCellEditor(this, cellEditor);
    }

    public E getItem() {
        return (E)this.getSelectedItem();
    }

    public void setItem(E item) {
        this.setSelectedItem(item);
    }

    @Override
    public void setPopupVisible(boolean visible) {
        JBPopupFactory jbPopupFactory;
        if (this.getModel().getSize() == 0 && visible) {
            return;
        }
        if (visible && (jbPopupFactory = ComboBox.getPopupFactory()) != null && jbPopupFactory.getChildFocusedPopup(this) != null) {
            return;
        }
        boolean wasShown = this.isPopupVisible();
        super.setPopupVisible(visible);
        if (!wasShown && visible && this.isEditable() && !UIManager.getBoolean("ComboBox.isEnterSelectablePopup")) {
            ComboBoxEditor editor = this.getEditor();
            Object item = editor.getItem();
            Object selectedItem = this.getSelectedItem();
            if (item == null || item != selectedItem) {
                this.configureEditor(editor, selectedItem);
            }
        }
    }

    @Nullable
    private static JBPopupFactory getPopupFactory() {
        if (ApplicationManager.getApplication() == null) {
            return null;
        }
        return JBPopupFactory.getInstance();
    }

    @Override
    public void eventDispatched(AWTEvent event) {
        if (event.getID() != 200) {
            return;
        }
        JBPopupFactory jbPopupFactory = ComboBox.getPopupFactory();
        if (jbPopupFactory == null) {
            return;
        }
        WindowEvent we = (WindowEvent)event;
        for (JBPopup each : jbPopupFactory.getChildPopups(this)) {
            if (each.isDisposed() || !SwingUtilities.isDescendingFrom(each.getContent(), we.getWindow())) continue;
            super.setPopupVisible(false);
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.getParent() instanceof JTable) {
            this.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
        }
        Toolkit.getDefaultToolkit().addAWTEventListener(this, 64L);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        Toolkit.getDefaultToolkit().removeAWTEventListener(this);
    }

    @Nullable
    public ComboPopup getPopup() {
        return UIUtil.getComboBoxPopup((JComboBox)this);
    }

    public void setSwingPopup(boolean swingPopup) {
        this.putClientProperty("ComboBox.jbPopup", swingPopup ? null : Boolean.valueOf(true));
        super.setEditor(null);
        this.updateUI();
    }

    public boolean isSwingPopup() {
        return this.getClientProperty("ComboBox.jbPopup") == null;
    }

    @Override
    public void setKeySelectionManager(JComboBox.KeySelectionManager aManager) {
        super.setKeySelectionManager(aManager == null || this.isSwingPopup() ? aManager : new JComboBox.KeySelectionManager(){

            public int selectionForKey(char aKey, ComboBoxModel aModel) {
                ComboBox.this.showPopup();
                return -1;
            }
        });
    }

    public void setMinimumAndPreferredWidth(int minimumAndPreferredWidth) {
        this.myMinimumAndPreferredWidth = minimumAndPreferredWidth;
    }

    private void registerCancelOnEscape() {
        this.registerKeyboardAction(e -> {
            DialogWrapper dialogWrapper = DialogWrapper.findInstance(this);
            if (this.isPopupVisible()) {
                this.setPopupVisible(false);
            } else {
                Object clientProperty = this.getClientProperty(TABLE_CELL_EDITOR_PROPERTY);
                if (clientProperty instanceof CellEditor) {
                    ((CellEditor)clientProperty).cancelCellEditing();
                } else if (dialogWrapper != null) {
                    dialogWrapper.doCancelAction();
                }
            }
        }, KeyStroke.getKeyStroke(27, 0), 1);
    }

    @Override
    public final void setEditor(ComboBoxEditor editor) {
        super.setEditor(new MyEditor(this, editor));
    }

    @Override
    public final Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        int width = this.myMinimumAndPreferredWidth;
        Dimension preferredSize = super.getPreferredSize();
        if (width < 0) {
            width = preferredSize.width;
        }
        return new Dimension(width, preferredSize.height);
    }

    @Override
    public void paint(Graphics g) {
        try {
            this.myPaintingNow = true;
            super.paint(g);
        }
        finally {
            this.myPaintingNow = false;
        }
    }

    @ApiStatus.Experimental
    public void initBrowsableEditor(final @NotNull Runnable browseAction, final @Nullable Disposable parentDisposable) {
        BasicComboBoxEditor editor = new BasicComboBoxEditor(){

            @Override
            protected JTextField createEditorComponent() {
                ExtendableTextField editor = new ExtendableTextField().addBrowseExtension(browseAction, parentDisposable);
                editor.setBorder(null);
                return editor;
            }
        };
        this.setEditor(editor);
        this.setEditable(true);
    }

    private static final class MyEditor
    implements ComboBoxEditor {
        private final JComboBox myComboBox;
        private final ComboBoxEditor myDelegate;

        MyEditor(JComboBox comboBox, ComboBoxEditor delegate) {
            this.myComboBox = comboBox;
            this.myDelegate = delegate;
            if (this.myDelegate != null) {
                this.myDelegate.addActionListener(e -> {
                    if (this.myComboBox.isPopupVisible()) {
                        this.myComboBox.setPopupVisible(false);
                    } else {
                        Object clientProperty = this.myComboBox.getClientProperty(ComboBox.TABLE_CELL_EDITOR_PROPERTY);
                        if (clientProperty instanceof CellEditor) {
                            ((CellEditor)clientProperty).stopCellEditing();
                        } else {
                            JButton button;
                            this.myComboBox.setSelectedItem(this.getItem());
                            JRootPane rootPane = this.myComboBox.getRootPane();
                            if (rootPane != null && (button = rootPane.getDefaultButton()) != null) {
                                button.doClick();
                            }
                        }
                    }
                });
            }
        }

        @Override
        public void addActionListener(ActionListener l) {
        }

        @Override
        public void removeActionListener(ActionListener l) {
        }

        @Override
        public Component getEditorComponent() {
            return this.myDelegate == null ? null : this.myDelegate.getEditorComponent();
        }

        @Override
        public Object getItem() {
            return this.myDelegate == null ? null : this.myDelegate.getItem();
        }

        @Override
        public void selectAll() {
            if (this.myDelegate != null) {
                this.myDelegate.selectAll();
            }
        }

        @Override
        public void setItem(Object obj) {
            if (this.myDelegate != null) {
                this.myDelegate.setItem(obj);
            }
        }
    }
}

