/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public class BrowseFolderRunnable<T extends JComponent>
implements Runnable {
    private final String myTitle;
    private final String myDescription;
    protected final TextComponentAccessor<? super T> myAccessor;
    protected final FileChooserDescriptor myFileChooserDescriptor;
    protected T myTextComponent;
    private Project myProject;

    public BrowseFolderRunnable(@Nullable @NlsContexts.DialogTitle String title, @Nullable @NlsContexts.Label String description, @Nullable Project project, FileChooserDescriptor fileChooserDescriptor, @Nullable T component, TextComponentAccessor<? super T> accessor) {
        if (fileChooserDescriptor != null && fileChooserDescriptor.isChooseMultiple()) {
            fileChooserDescriptor = new FileChooserDescriptor(fileChooserDescriptor){

                @Override
                public boolean isChooseMultiple() {
                    return false;
                }
            };
        }
        this.myTitle = title;
        this.myDescription = description;
        this.myTextComponent = component;
        this.myProject = project;
        this.myFileChooserDescriptor = fileChooserDescriptor;
        this.myAccessor = accessor;
    }

    @Nullable
    protected Project getProject() {
        return this.myProject;
    }

    protected void setProject(@Nullable Project project) {
        this.myProject = project;
    }

    @Override
    public void run() {
        FileChooserDescriptor fileChooserDescriptor = this.myFileChooserDescriptor;
        if (this.myTitle != null || this.myDescription != null) {
            fileChooserDescriptor = (FileChooserDescriptor)this.myFileChooserDescriptor.clone();
            if (this.myTitle != null) {
                fileChooserDescriptor.setTitle(this.myTitle);
            }
            if (this.myDescription != null) {
                fileChooserDescriptor.setDescription(this.myDescription);
            }
        }
        FileChooser.chooseFile(fileChooserDescriptor, this.getProject(), this.myTextComponent, this.getInitialFile(), (Consumer<? super VirtualFile>)((Consumer)this::onFileChosen));
    }

    @Nullable
    protected VirtualFile getInitialFile() {
        int pos;
        String directoryName = this.myAccessor.getText(this.myTextComponent).trim();
        if (StringUtil.isEmptyOrSpaces((String)directoryName)) {
            return null;
        }
        directoryName = FileUtil.toSystemIndependentName((String)directoryName);
        VirtualFile path2 = LocalFileSystem.getInstance().findFileByPath(this.expandPath(directoryName));
        while (path2 == null && directoryName.length() > 0 && (pos = directoryName.lastIndexOf(47)) > 0) {
            directoryName = directoryName.substring(0, pos);
            path2 = LocalFileSystem.getInstance().findFileByPath(directoryName);
        }
        return path2;
    }

    @NotNull
    protected String expandPath(@NotNull String path2) {
        return path2;
    }

    @NotNull
    protected String chosenFileToResultingText(@NotNull VirtualFile chosenFile) {
        return chosenFile.getPresentableUrl();
    }

    protected String getComponentText() {
        return this.myAccessor.getText(this.myTextComponent).trim();
    }

    protected void onFileChosen(@NotNull VirtualFile chosenFile) {
        this.myAccessor.setText(this.myTextComponent, this.chosenFileToResultingText(chosenFile));
    }
}

